/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.UpdateStackDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateStackRequest
extends BmcRequest<UpdateStackDetails> {
    private String stackId;
    private UpdateStackDetails updateStackDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getStackId() {
        return this.stackId;
    }

    public UpdateStackDetails getUpdateStackDetails() {
        return this.updateStackDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateStackDetails getBody$() {
        return this.updateStackDetails;
    }

    public Builder toBuilder() {
        return new Builder().stackId(this.stackId).updateStackDetails(this.updateStackDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",stackId=").append(String.valueOf(this.stackId));
        sb.append(",updateStackDetails=").append(String.valueOf((Object)this.updateStackDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.stackId, other.stackId) && Objects.equals((Object)this.updateStackDetails, (Object)other.updateStackDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.updateStackDetails == null ? 43 : this.updateStackDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateStackRequest, UpdateStackDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String stackId = null;
        private UpdateStackDetails updateStackDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public Builder updateStackDetails(UpdateStackDetails updateStackDetails) {
            this.updateStackDetails = updateStackDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStackRequest o) {
            this.stackId(o.getStackId());
            this.updateStackDetails(o.getUpdateStackDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStackRequest build() {
            UpdateStackRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateStackDetails body) {
            this.updateStackDetails(body);
            return this;
        }

        public UpdateStackRequest buildWithoutInvocationCallback() {
            UpdateStackRequest request = new UpdateStackRequest();
            request.stackId = this.stackId;
            request.updateStackDetails = this.updateStackDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

