/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.DetectStackDriftDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetectStackDriftRequest
extends BmcRequest<DetectStackDriftDetails> {
    private String stackId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private DetectStackDriftDetails detectStackDriftDetails;

    public String getStackId() {
        return this.stackId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public DetectStackDriftDetails getDetectStackDriftDetails() {
        return this.detectStackDriftDetails;
    }

    @InternalSdk
    public DetectStackDriftDetails getBody$() {
        return this.detectStackDriftDetails;
    }

    public Builder toBuilder() {
        return new Builder().stackId(this.stackId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).detectStackDriftDetails(this.detectStackDriftDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",stackId=").append(String.valueOf(this.stackId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",detectStackDriftDetails=").append(String.valueOf((Object)this.detectStackDriftDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectStackDriftRequest)) {
            return false;
        }
        DetectStackDriftRequest other = (DetectStackDriftRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.stackId, other.stackId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.detectStackDriftDetails, (Object)other.detectStackDriftDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.detectStackDriftDetails == null ? 43 : this.detectStackDriftDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetectStackDriftRequest, DetectStackDriftDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String stackId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private DetectStackDriftDetails detectStackDriftDetails = null;

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder detectStackDriftDetails(DetectStackDriftDetails detectStackDriftDetails) {
            this.detectStackDriftDetails = detectStackDriftDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetectStackDriftRequest o) {
            this.stackId(o.getStackId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.detectStackDriftDetails(o.getDetectStackDriftDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetectStackDriftRequest build() {
            DetectStackDriftRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DetectStackDriftDetails body) {
            this.detectStackDriftDetails(body);
            return this;
        }

        public DetectStackDriftRequest buildWithoutInvocationCallback() {
            DetectStackDriftRequest request = new DetectStackDriftRequest();
            request.stackId = this.stackId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.detectStackDriftDetails = this.detectStackDriftDetails;
            return request;
        }
    }
}

