/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.resourcemanager.model.ConfigSourceRecord;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceRecordType")
@JsonFilter(value="explicitlySetFilter")
public final class DevOpsConfigSourceRecord
extends ConfigSourceRecord {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="branchName")
    private final String branchName;
    @JsonProperty(value="commitId")
    private final String commitId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DevOpsConfigSourceRecord(String projectId, String repositoryId, String branchName, String commitId) {
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.branchName = branchName;
        this.commitId = commitId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getCommitId() {
        return this.commitId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DevOpsConfigSourceRecord(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", branchName=").append(String.valueOf(this.branchName));
        sb.append(", commitId=").append(String.valueOf(this.commitId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevOpsConfigSourceRecord)) {
            return false;
        }
        DevOpsConfigSourceRecord other = (DevOpsConfigSourceRecord)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.branchName, other.branchName) && Objects.equals(this.commitId, other.commitId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.branchName == null ? 43 : this.branchName.hashCode());
        result = result * 59 + (this.commitId == null ? 43 : this.commitId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="branchName")
        private String branchName;
        @JsonProperty(value="commitId")
        private String commitId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder branchName(String branchName) {
            this.branchName = branchName;
            this.__explicitlySet__.add("branchName");
            return this;
        }

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            this.__explicitlySet__.add("commitId");
            return this;
        }

        public DevOpsConfigSourceRecord build() {
            DevOpsConfigSourceRecord model = new DevOpsConfigSourceRecord(this.projectId, this.repositoryId, this.branchName, this.commitId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DevOpsConfigSourceRecord model) {
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("branchName")) {
                this.branchName(model.getBranchName());
            }
            if (model.wasPropertyExplicitlySet("commitId")) {
                this.commitId(model.getCommitId());
            }
            return this;
        }
    }
}

