/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcemanager.model.BitbucketCloudUsernameAppPasswordConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.BitbucketServerAccessTokenConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.GithubAccessTokenConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.GitlabAccessTokenConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.PrivateServerConfigDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceProviderType", defaultImpl=ConfigurationSourceProvider.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GithubAccessTokenConfigurationSourceProvider.class, name="GITHUB_ACCESS_TOKEN"), @JsonSubTypes.Type(value=GitlabAccessTokenConfigurationSourceProvider.class, name="GITLAB_ACCESS_TOKEN"), @JsonSubTypes.Type(value=BitbucketServerAccessTokenConfigurationSourceProvider.class, name="BITBUCKET_SERVER_ACCESS_TOKEN"), @JsonSubTypes.Type(value=BitbucketCloudUsernameAppPasswordConfigurationSourceProvider.class, name="BITBUCKET_CLOUD_USERNAME_APPPASSWORD")})
@JsonFilter(value="explicitlySetFilter")
public class ConfigurationSourceProvider
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="privateServerConfigDetails")
    private final PrivateServerConfigDetails privateServerConfigDetails;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "timeCreated", "lifecycleState", "privateServerConfigDetails", "username", "secretId", "freeformTags", "definedTags"})
    protected ConfigurationSourceProvider(String id, String compartmentId, String displayName, String description, Date timeCreated, LifecycleState lifecycleState, PrivateServerConfigDetails privateServerConfigDetails, String username, String secretId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.privateServerConfigDetails = privateServerConfigDetails;
        this.username = username;
        this.secretId = secretId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public PrivateServerConfigDetails getPrivateServerConfigDetails() {
        return this.privateServerConfigDetails;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigurationSourceProvider(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", privateServerConfigDetails=").append(String.valueOf((Object)this.privateServerConfigDetails));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationSourceProvider)) {
            return false;
        }
        ConfigurationSourceProvider other = (ConfigurationSourceProvider)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.privateServerConfigDetails, (Object)other.privateServerConfigDetails) && Objects.equals(this.username, other.username) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.privateServerConfigDetails == null ? 43 : this.privateServerConfigDetails.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConfigSourceProviderType implements BmcEnum
    {
        BitbucketCloudUsernameApppassword("BITBUCKET_CLOUD_USERNAME_APPPASSWORD"),
        BitbucketServerAccessToken("BITBUCKET_SERVER_ACCESS_TOKEN"),
        GitlabAccessToken("GITLAB_ACCESS_TOKEN"),
        GithubAccessToken("GITHUB_ACCESS_TOKEN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConfigSourceProviderType> map;

        private ConfigSourceProviderType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigSourceProviderType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConfigSourceProviderType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConfigSourceProviderType.class);
            map = new HashMap<String, ConfigSourceProviderType>();
            for (ConfigSourceProviderType v : ConfigSourceProviderType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

