/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcemanager.model.BitbucketCloudConfigSource;
import com.oracle.bmc.resourcemanager.model.BitbucketServerConfigSource;
import com.oracle.bmc.resourcemanager.model.CompartmentConfigSource;
import com.oracle.bmc.resourcemanager.model.DevOpsConfigSource;
import com.oracle.bmc.resourcemanager.model.GitConfigSource;
import com.oracle.bmc.resourcemanager.model.ObjectStorageConfigSource;
import com.oracle.bmc.resourcemanager.model.ZipUploadConfigSource;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceType", defaultImpl=ConfigSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GitConfigSource.class, name="GIT_CONFIG_SOURCE"), @JsonSubTypes.Type(value=DevOpsConfigSource.class, name="DEVOPS_CONFIG_SOURCE"), @JsonSubTypes.Type(value=ObjectStorageConfigSource.class, name="OBJECT_STORAGE_CONFIG_SOURCE"), @JsonSubTypes.Type(value=BitbucketServerConfigSource.class, name="BITBUCKET_SERVER_CONFIG_SOURCE"), @JsonSubTypes.Type(value=BitbucketCloudConfigSource.class, name="BITBUCKET_CLOUD_CONFIG_SOURCE"), @JsonSubTypes.Type(value=CompartmentConfigSource.class, name="COMPARTMENT_CONFIG_SOURCE"), @JsonSubTypes.Type(value=ZipUploadConfigSource.class, name="ZIP_UPLOAD")})
@JsonFilter(value="explicitlySetFilter")
public class ConfigSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="workingDirectory")
    private final String workingDirectory;

    @Deprecated
    @ConstructorProperties(value={"workingDirectory"})
    protected ConfigSource(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigSource(");
        sb.append("super=").append(super.toString());
        sb.append("workingDirectory=").append(String.valueOf(this.workingDirectory));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigSource)) {
            return false;
        }
        ConfigSource other = (ConfigSource)((Object)o);
        return Objects.equals(this.workingDirectory, other.workingDirectory) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.workingDirectory == null ? 43 : this.workingDirectory.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConfigSourceType implements BmcEnum
    {
        BitbucketCloudConfigSource("BITBUCKET_CLOUD_CONFIG_SOURCE"),
        BitbucketServerConfigSource("BITBUCKET_SERVER_CONFIG_SOURCE"),
        CompartmentConfigSource("COMPARTMENT_CONFIG_SOURCE"),
        DevopsConfigSource("DEVOPS_CONFIG_SOURCE"),
        GitConfigSource("GIT_CONFIG_SOURCE"),
        ObjectStorageConfigSource("OBJECT_STORAGE_CONFIG_SOURCE"),
        ZipUpload("ZIP_UPLOAD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConfigSourceType> map;

        private ConfigSourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigSourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConfigSourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConfigSourceType.class);
            map = new HashMap<String, ConfigSourceType>();
            for (ConfigSourceType v : ConfigSourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

