/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcemanager.model.JobOperationDetails;
import com.oracle.bmc.resourcemanager.model.TerraformAdvancedOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="operation")
@JsonFilter(value="explicitlySetFilter")
public final class ApplyJobOperationDetails
extends JobOperationDetails {
    @JsonProperty(value="terraformAdvancedOptions")
    private final TerraformAdvancedOptions terraformAdvancedOptions;
    @JsonProperty(value="executionPlanStrategy")
    private final ExecutionPlanStrategy executionPlanStrategy;
    @JsonProperty(value="executionPlanJobId")
    private final String executionPlanJobId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ApplyJobOperationDetails(TerraformAdvancedOptions terraformAdvancedOptions, ExecutionPlanStrategy executionPlanStrategy, String executionPlanJobId) {
        this.terraformAdvancedOptions = terraformAdvancedOptions;
        this.executionPlanStrategy = executionPlanStrategy;
        this.executionPlanJobId = executionPlanJobId;
    }

    public TerraformAdvancedOptions getTerraformAdvancedOptions() {
        return this.terraformAdvancedOptions;
    }

    public ExecutionPlanStrategy getExecutionPlanStrategy() {
        return this.executionPlanStrategy;
    }

    public String getExecutionPlanJobId() {
        return this.executionPlanJobId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplyJobOperationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", terraformAdvancedOptions=").append(String.valueOf((Object)this.terraformAdvancedOptions));
        sb.append(", executionPlanStrategy=").append(String.valueOf((Object)this.executionPlanStrategy));
        sb.append(", executionPlanJobId=").append(String.valueOf(this.executionPlanJobId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplyJobOperationDetails)) {
            return false;
        }
        ApplyJobOperationDetails other = (ApplyJobOperationDetails)((Object)o);
        return Objects.equals((Object)this.terraformAdvancedOptions, (Object)other.terraformAdvancedOptions) && Objects.equals((Object)this.executionPlanStrategy, (Object)other.executionPlanStrategy) && Objects.equals(this.executionPlanJobId, other.executionPlanJobId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.terraformAdvancedOptions == null ? 43 : this.terraformAdvancedOptions.hashCode());
        result = result * 59 + (this.executionPlanStrategy == null ? 43 : this.executionPlanStrategy.hashCode());
        result = result * 59 + (this.executionPlanJobId == null ? 43 : this.executionPlanJobId.hashCode());
        return result;
    }

    public static enum ExecutionPlanStrategy implements BmcEnum
    {
        FromPlanJobId("FROM_PLAN_JOB_ID"),
        FromLatestPlanJob("FROM_LATEST_PLAN_JOB"),
        AutoApproved("AUTO_APPROVED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExecutionPlanStrategy> map;

        private ExecutionPlanStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExecutionPlanStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExecutionPlanStrategy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExecutionPlanStrategy.class);
            map = new HashMap<String, ExecutionPlanStrategy>();
            for (ExecutionPlanStrategy v : ExecutionPlanStrategy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="terraformAdvancedOptions")
        private TerraformAdvancedOptions terraformAdvancedOptions;
        @JsonProperty(value="executionPlanStrategy")
        private ExecutionPlanStrategy executionPlanStrategy;
        @JsonProperty(value="executionPlanJobId")
        private String executionPlanJobId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder terraformAdvancedOptions(TerraformAdvancedOptions terraformAdvancedOptions) {
            this.terraformAdvancedOptions = terraformAdvancedOptions;
            this.__explicitlySet__.add("terraformAdvancedOptions");
            return this;
        }

        public Builder executionPlanStrategy(ExecutionPlanStrategy executionPlanStrategy) {
            this.executionPlanStrategy = executionPlanStrategy;
            this.__explicitlySet__.add("executionPlanStrategy");
            return this;
        }

        public Builder executionPlanJobId(String executionPlanJobId) {
            this.executionPlanJobId = executionPlanJobId;
            this.__explicitlySet__.add("executionPlanJobId");
            return this;
        }

        public ApplyJobOperationDetails build() {
            ApplyJobOperationDetails model = new ApplyJobOperationDetails(this.terraformAdvancedOptions, this.executionPlanStrategy, this.executionPlanJobId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplyJobOperationDetails model) {
            if (model.wasPropertyExplicitlySet("terraformAdvancedOptions")) {
                this.terraformAdvancedOptions(model.getTerraformAdvancedOptions());
            }
            if (model.wasPropertyExplicitlySet("executionPlanStrategy")) {
                this.executionPlanStrategy(model.getExecutionPlanStrategy());
            }
            if (model.wasPropertyExplicitlySet("executionPlanJobId")) {
                this.executionPlanJobId(model.getExecutionPlanJobId());
            }
            return this;
        }
    }
}

