/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.model.AssociatedResourceSummary;
import com.oracle.bmc.resourcemanager.model.ConfigurationSourceProviderSummary;
import com.oracle.bmc.resourcemanager.model.JobOutputSummary;
import com.oracle.bmc.resourcemanager.model.JobSummary;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.resourcemanager.model.PrivateEndpointSummary;
import com.oracle.bmc.resourcemanager.model.StackResourceDriftSummary;
import com.oracle.bmc.resourcemanager.model.StackSummary;
import com.oracle.bmc.resourcemanager.model.TemplateSummary;
import com.oracle.bmc.resourcemanager.model.WorkRequestError;
import com.oracle.bmc.resourcemanager.model.WorkRequestLogEntry;
import com.oracle.bmc.resourcemanager.model.WorkRequestSummary;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListConfigurationSourceProvidersRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobAssociatedResourcesRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobOutputsRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackAssociatedResourcesRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplatesRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListConfigurationSourceProvidersResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobAssociatedResourcesResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobOutputsResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackAssociatedResourcesResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplatesResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResourceManagerPaginators {
    private final ResourceManager client;

    public ResourceManagerPaginators(ResourceManager client) {
        this.client = client;
    }

    public Iterable<GetJobLogsResponse> getJobLogsResponseIterator(final GetJobLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<GetJobLogsRequest.Builder>(){

            @Override
            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetJobLogsResponse, String>(){

            @Override
            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            @Override
            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            @Override
            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        });
    }

    public Iterable<LogEntry> getJobLogsRecordIterator(final GetJobLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<GetJobLogsRequest.Builder>(){

            @Override
            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<GetJobLogsResponse, String>(){

            @Override
            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            @Override
            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((GetJobLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            @Override
            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        }, (Function)new Function<GetJobLogsResponse, List<LogEntry>>(){

            @Override
            public List<LogEntry> apply(GetJobLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListConfigurationSourceProvidersResponse> listConfigurationSourceProvidersResponseIterator(final ListConfigurationSourceProvidersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListConfigurationSourceProvidersRequest.Builder>(){

            @Override
            public ListConfigurationSourceProvidersRequest.Builder get() {
                return ListConfigurationSourceProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, String>(){

            @Override
            public String apply(ListConfigurationSourceProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder>, ListConfigurationSourceProvidersRequest>(){

            @Override
            public ListConfigurationSourceProvidersRequest apply(RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse>(){

            @Override
            public ListConfigurationSourceProvidersResponse apply(ListConfigurationSourceProvidersRequest request) {
                return ResourceManagerPaginators.this.client.listConfigurationSourceProviders(request);
            }
        });
    }

    public Iterable<ConfigurationSourceProviderSummary> listConfigurationSourceProvidersRecordIterator(final ListConfigurationSourceProvidersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListConfigurationSourceProvidersRequest.Builder>(){

            @Override
            public ListConfigurationSourceProvidersRequest.Builder get() {
                return ListConfigurationSourceProvidersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, String>(){

            @Override
            public String apply(ListConfigurationSourceProvidersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder>, ListConfigurationSourceProvidersRequest>(){

            @Override
            public ListConfigurationSourceProvidersRequest apply(RequestBuilderAndToken<ListConfigurationSourceProvidersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListConfigurationSourceProvidersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListConfigurationSourceProvidersRequest, ListConfigurationSourceProvidersResponse>(){

            @Override
            public ListConfigurationSourceProvidersResponse apply(ListConfigurationSourceProvidersRequest request) {
                return ResourceManagerPaginators.this.client.listConfigurationSourceProviders(request);
            }
        }, (Function)new Function<ListConfigurationSourceProvidersResponse, List<ConfigurationSourceProviderSummary>>(){

            @Override
            public List<ConfigurationSourceProviderSummary> apply(ListConfigurationSourceProvidersResponse response) {
                return response.getConfigurationSourceProviderCollection().getItems();
            }
        });
    }

    public Iterable<ListJobAssociatedResourcesResponse> listJobAssociatedResourcesResponseIterator(final ListJobAssociatedResourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobAssociatedResourcesRequest.Builder>(){

            @Override
            public ListJobAssociatedResourcesRequest.Builder get() {
                return ListJobAssociatedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobAssociatedResourcesResponse, String>(){

            @Override
            public String apply(ListJobAssociatedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobAssociatedResourcesRequest.Builder>, ListJobAssociatedResourcesRequest>(){

            @Override
            public ListJobAssociatedResourcesRequest apply(RequestBuilderAndToken<ListJobAssociatedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobAssociatedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobAssociatedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobAssociatedResourcesRequest, ListJobAssociatedResourcesResponse>(){

            @Override
            public ListJobAssociatedResourcesResponse apply(ListJobAssociatedResourcesRequest request) {
                return ResourceManagerPaginators.this.client.listJobAssociatedResources(request);
            }
        });
    }

    public Iterable<AssociatedResourceSummary> listJobAssociatedResourcesRecordIterator(final ListJobAssociatedResourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobAssociatedResourcesRequest.Builder>(){

            @Override
            public ListJobAssociatedResourcesRequest.Builder get() {
                return ListJobAssociatedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobAssociatedResourcesResponse, String>(){

            @Override
            public String apply(ListJobAssociatedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobAssociatedResourcesRequest.Builder>, ListJobAssociatedResourcesRequest>(){

            @Override
            public ListJobAssociatedResourcesRequest apply(RequestBuilderAndToken<ListJobAssociatedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobAssociatedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobAssociatedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobAssociatedResourcesRequest, ListJobAssociatedResourcesResponse>(){

            @Override
            public ListJobAssociatedResourcesResponse apply(ListJobAssociatedResourcesRequest request) {
                return ResourceManagerPaginators.this.client.listJobAssociatedResources(request);
            }
        }, (Function)new Function<ListJobAssociatedResourcesResponse, List<AssociatedResourceSummary>>(){

            @Override
            public List<AssociatedResourceSummary> apply(ListJobAssociatedResourcesResponse response) {
                return response.getAssociatedResourcesCollection().getItems();
            }
        });
    }

    public Iterable<ListJobOutputsResponse> listJobOutputsResponseIterator(final ListJobOutputsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobOutputsRequest.Builder>(){

            @Override
            public ListJobOutputsRequest.Builder get() {
                return ListJobOutputsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, String>(){

            @Override
            public String apply(ListJobOutputsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobOutputsRequest.Builder>, ListJobOutputsRequest>(){

            @Override
            public ListJobOutputsRequest apply(RequestBuilderAndToken<ListJobOutputsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobOutputsRequest, ListJobOutputsResponse>(){

            @Override
            public ListJobOutputsResponse apply(ListJobOutputsRequest request) {
                return ResourceManagerPaginators.this.client.listJobOutputs(request);
            }
        });
    }

    public Iterable<JobOutputSummary> listJobOutputsRecordIterator(final ListJobOutputsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobOutputsRequest.Builder>(){

            @Override
            public ListJobOutputsRequest.Builder get() {
                return ListJobOutputsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, String>(){

            @Override
            public String apply(ListJobOutputsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobOutputsRequest.Builder>, ListJobOutputsRequest>(){

            @Override
            public ListJobOutputsRequest apply(RequestBuilderAndToken<ListJobOutputsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobOutputsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobOutputsRequest, ListJobOutputsResponse>(){

            @Override
            public ListJobOutputsResponse apply(ListJobOutputsRequest request) {
                return ResourceManagerPaginators.this.client.listJobOutputs(request);
            }
        }, (Function)new Function<ListJobOutputsResponse, List<JobOutputSummary>>(){

            @Override
            public List<JobOutputSummary> apply(ListJobOutputsResponse response) {
                return response.getJobOutputsCollection().getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            @Override
            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            @Override
            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            @Override
            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            @Override
            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJobsRequest.Builder>(){

            @Override
            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJobsResponse, String>(){

            @Override
            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            @Override
            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJobsRequest, ListJobsResponse>(){

            @Override
            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        }, (Function)new Function<ListJobsResponse, List<JobSummary>>(){

            @Override
            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPrivateEndpointsResponse> listPrivateEndpointsResponseIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return ResourceManagerPaginators.this.client.listPrivateEndpoints(request);
            }
        });
    }

    public Iterable<PrivateEndpointSummary> listPrivateEndpointsRecordIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            @Override
            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            @Override
            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            @Override
            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return ResourceManagerPaginators.this.client.listPrivateEndpoints(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, List<PrivateEndpointSummary>>(){

            @Override
            public List<PrivateEndpointSummary> apply(ListPrivateEndpointsResponse response) {
                return response.getPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListStackAssociatedResourcesResponse> listStackAssociatedResourcesResponseIterator(final ListStackAssociatedResourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStackAssociatedResourcesRequest.Builder>(){

            @Override
            public ListStackAssociatedResourcesRequest.Builder get() {
                return ListStackAssociatedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackAssociatedResourcesResponse, String>(){

            @Override
            public String apply(ListStackAssociatedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackAssociatedResourcesRequest.Builder>, ListStackAssociatedResourcesRequest>(){

            @Override
            public ListStackAssociatedResourcesRequest apply(RequestBuilderAndToken<ListStackAssociatedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStackAssociatedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackAssociatedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStackAssociatedResourcesRequest, ListStackAssociatedResourcesResponse>(){

            @Override
            public ListStackAssociatedResourcesResponse apply(ListStackAssociatedResourcesRequest request) {
                return ResourceManagerPaginators.this.client.listStackAssociatedResources(request);
            }
        });
    }

    public Iterable<AssociatedResourceSummary> listStackAssociatedResourcesRecordIterator(final ListStackAssociatedResourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStackAssociatedResourcesRequest.Builder>(){

            @Override
            public ListStackAssociatedResourcesRequest.Builder get() {
                return ListStackAssociatedResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackAssociatedResourcesResponse, String>(){

            @Override
            public String apply(ListStackAssociatedResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackAssociatedResourcesRequest.Builder>, ListStackAssociatedResourcesRequest>(){

            @Override
            public ListStackAssociatedResourcesRequest apply(RequestBuilderAndToken<ListStackAssociatedResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStackAssociatedResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackAssociatedResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStackAssociatedResourcesRequest, ListStackAssociatedResourcesResponse>(){

            @Override
            public ListStackAssociatedResourcesResponse apply(ListStackAssociatedResourcesRequest request) {
                return ResourceManagerPaginators.this.client.listStackAssociatedResources(request);
            }
        }, (Function)new Function<ListStackAssociatedResourcesResponse, List<AssociatedResourceSummary>>(){

            @Override
            public List<AssociatedResourceSummary> apply(ListStackAssociatedResourcesResponse response) {
                return response.getAssociatedResourcesCollection().getItems();
            }
        });
    }

    public Iterable<ListStackResourceDriftDetailsResponse> listStackResourceDriftDetailsResponseIterator(final ListStackResourceDriftDetailsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStackResourceDriftDetailsRequest.Builder>(){

            @Override
            public ListStackResourceDriftDetailsRequest.Builder get() {
                return ListStackResourceDriftDetailsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, String>(){

            @Override
            public String apply(ListStackResourceDriftDetailsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder>, ListStackResourceDriftDetailsRequest>(){

            @Override
            public ListStackResourceDriftDetailsRequest apply(RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse>(){

            @Override
            public ListStackResourceDriftDetailsResponse apply(ListStackResourceDriftDetailsRequest request) {
                return ResourceManagerPaginators.this.client.listStackResourceDriftDetails(request);
            }
        });
    }

    public Iterable<StackResourceDriftSummary> listStackResourceDriftDetailsRecordIterator(final ListStackResourceDriftDetailsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStackResourceDriftDetailsRequest.Builder>(){

            @Override
            public ListStackResourceDriftDetailsRequest.Builder get() {
                return ListStackResourceDriftDetailsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, String>(){

            @Override
            public String apply(ListStackResourceDriftDetailsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder>, ListStackResourceDriftDetailsRequest>(){

            @Override
            public ListStackResourceDriftDetailsRequest apply(RequestBuilderAndToken<ListStackResourceDriftDetailsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStackResourceDriftDetailsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStackResourceDriftDetailsRequest, ListStackResourceDriftDetailsResponse>(){

            @Override
            public ListStackResourceDriftDetailsResponse apply(ListStackResourceDriftDetailsRequest request) {
                return ResourceManagerPaginators.this.client.listStackResourceDriftDetails(request);
            }
        }, (Function)new Function<ListStackResourceDriftDetailsResponse, List<StackResourceDriftSummary>>(){

            @Override
            public List<StackResourceDriftSummary> apply(ListStackResourceDriftDetailsResponse response) {
                return response.getStackResourceDriftCollection().getItems();
            }
        });
    }

    public Iterable<ListStacksResponse> listStacksResponseIterator(final ListStacksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListStacksRequest.Builder>(){

            @Override
            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStacksResponse, String>(){

            @Override
            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            @Override
            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStacksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStacksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStacksRequest, ListStacksResponse>(){

            @Override
            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        });
    }

    public Iterable<StackSummary> listStacksRecordIterator(final ListStacksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListStacksRequest.Builder>(){

            @Override
            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListStacksResponse, String>(){

            @Override
            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            @Override
            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListStacksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListStacksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListStacksRequest, ListStacksResponse>(){

            @Override
            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        }, (Function)new Function<ListStacksResponse, List<StackSummary>>(){

            @Override
            public List<StackSummary> apply(ListStacksResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListTemplatesResponse> listTemplatesResponseIterator(final ListTemplatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTemplatesRequest.Builder>(){

            @Override
            public ListTemplatesRequest.Builder get() {
                return ListTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTemplatesResponse, String>(){

            @Override
            public String apply(ListTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTemplatesRequest.Builder>, ListTemplatesRequest>(){

            @Override
            public ListTemplatesRequest apply(RequestBuilderAndToken<ListTemplatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTemplatesRequest, ListTemplatesResponse>(){

            @Override
            public ListTemplatesResponse apply(ListTemplatesRequest request) {
                return ResourceManagerPaginators.this.client.listTemplates(request);
            }
        });
    }

    public Iterable<TemplateSummary> listTemplatesRecordIterator(final ListTemplatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTemplatesRequest.Builder>(){

            @Override
            public ListTemplatesRequest.Builder get() {
                return ListTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTemplatesResponse, String>(){

            @Override
            public String apply(ListTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTemplatesRequest.Builder>, ListTemplatesRequest>(){

            @Override
            public ListTemplatesRequest apply(RequestBuilderAndToken<ListTemplatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTemplatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTemplatesRequest, ListTemplatesResponse>(){

            @Override
            public ListTemplatesResponse apply(ListTemplatesRequest request) {
                return ResourceManagerPaginators.this.client.listTemplates(request);
            }
        }, (Function)new Function<ListTemplatesResponse, List<TemplateSummary>>(){

            @Override
            public List<TemplateSummary> apply(ListTemplatesResponse response) {
                return response.getTemplateSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

