/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubusage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osubusage.ComputedUsageAsync;
import com.oracle.bmc.osubusage.model.ComputedUsage;
import com.oracle.bmc.osubusage.model.ComputedUsageAggregatedSummary;
import com.oracle.bmc.osubusage.model.ComputedUsageSummary;
import com.oracle.bmc.osubusage.requests.GetComputedUsageRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsageAggregatedsRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsagesRequest;
import com.oracle.bmc.osubusage.responses.GetComputedUsageResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsageAggregatedsResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedUsageAsyncClient
extends BaseAsyncClient
implements ComputedUsageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEDUSAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://csaap-e.oracle.com").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputedUsageAsyncClient.class);

    private ComputedUsageAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetComputedUsageResponse> getComputedUsage(GetComputedUsageRequest request, AsyncHandler<GetComputedUsageRequest, GetComputedUsageResponse> handler) {
        Validate.notBlank((String)request.getComputedUsageId(), (String)"computedUsageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetComputedUsageResponse::builder).logger(LOG, "getComputedUsage").serviceDetails("ComputedUsage", "GetComputedUsage", "").method(Method.GET).requestBuilder(GetComputedUsageRequest::builder).basePath("/oalapp/service/onesubs/proxy/20210501").appendPathParam("computedUsages").appendPathParam(request.getComputedUsageId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("x-one-origin-region", request.getXOneOriginRegion()).handleBody(ComputedUsage.class, GetComputedUsageResponse.Builder::computedUsage).handleResponseHeaderString("opc-request-id", GetComputedUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputedUsageAggregatedsResponse> listComputedUsageAggregateds(ListComputedUsageAggregatedsRequest request, AsyncHandler<ListComputedUsageAggregatedsRequest, ListComputedUsageAggregatedsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        Objects.requireNonNull(request.getTimeFrom(), "timeFrom is required");
        Objects.requireNonNull(request.getTimeTo(), "timeTo is required");
        return this.clientCall(request, ListComputedUsageAggregatedsResponse::builder).logger(LOG, "listComputedUsageAggregateds").serviceDetails("ComputedUsage", "ListComputedUsageAggregateds", "").method(Method.GET).requestBuilder(ListComputedUsageAggregatedsRequest::builder).basePath("/oalapp/service/onesubs/proxy/20210501").appendPathParam("computedUsages").appendPathParam("aggregated").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("timeFrom", (Object)request.getTimeFrom()).appendQueryParam("timeTo", (Object)request.getTimeTo()).appendQueryParam("parentProduct", (Object)request.getParentProduct()).appendEnumQueryParam("grouping", (BmcEnum)request.getGrouping()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("x-one-origin-region", request.getXOneOriginRegion()).handleBodyList(ComputedUsageAggregatedSummary.class, ListComputedUsageAggregatedsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputedUsageAggregatedsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputedUsageAggregatedsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputedUsagesResponse> listComputedUsages(ListComputedUsagesRequest request, AsyncHandler<ListComputedUsagesRequest, ListComputedUsagesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        Objects.requireNonNull(request.getTimeFrom(), "timeFrom is required");
        Objects.requireNonNull(request.getTimeTo(), "timeTo is required");
        return this.clientCall(request, ListComputedUsagesResponse::builder).logger(LOG, "listComputedUsages").serviceDetails("ComputedUsage", "ListComputedUsages", "").method(Method.GET).requestBuilder(ListComputedUsagesRequest::builder).basePath("/oalapp/service/onesubs/proxy/20210501").appendPathParam("computedUsages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("timeFrom", (Object)request.getTimeFrom()).appendQueryParam("timeTo", (Object)request.getTimeTo()).appendQueryParam("parentProduct", (Object)request.getParentProduct()).appendQueryParam("computedProduct", (Object)request.getComputedProduct()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("x-one-origin-region", request.getXOneOriginRegion()).handleBodyList(ComputedUsageSummary.class, ListComputedUsagesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputedUsagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputedUsagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ComputedUsageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputedUsageAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputedUsageAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputedUsageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputedUsageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputedUsageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputedUsageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputedUsageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputedUsageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputedUsageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputedUsageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputedUsageAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

