/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListInvoicesRequest
extends BmcRequest<Void> {
    private String ospHomeRegion;
    private String compartmentId;
    private String opcRequestId;
    private String invoiceId;
    private List<Type> type;
    private String searchText;
    private Date timeInvoiceStart;
    private Date timeInvoiceEnd;
    private Date timePaymentStart;
    private Date timePaymentEnd;
    private List<Status> status;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public List<Type> getType() {
        return this.type;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public Date getTimeInvoiceStart() {
        return this.timeInvoiceStart;
    }

    public Date getTimeInvoiceEnd() {
        return this.timeInvoiceEnd;
    }

    public Date getTimePaymentStart() {
        return this.timePaymentStart;
    }

    public Date getTimePaymentEnd() {
        return this.timePaymentEnd;
    }

    public List<Status> getStatus() {
        return this.status;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().ospHomeRegion(this.ospHomeRegion).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).invoiceId(this.invoiceId).type(this.type).searchText(this.searchText).timeInvoiceStart(this.timeInvoiceStart).timeInvoiceEnd(this.timeInvoiceEnd).timePaymentStart(this.timePaymentStart).timePaymentEnd(this.timePaymentEnd).status(this.status).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",invoiceId=").append(String.valueOf(this.invoiceId));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",searchText=").append(String.valueOf(this.searchText));
        sb.append(",timeInvoiceStart=").append(String.valueOf(this.timeInvoiceStart));
        sb.append(",timeInvoiceEnd=").append(String.valueOf(this.timeInvoiceEnd));
        sb.append(",timePaymentStart=").append(String.valueOf(this.timePaymentStart));
        sb.append(",timePaymentEnd=").append(String.valueOf(this.timePaymentEnd));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListInvoicesRequest)) {
            return false;
        }
        ListInvoicesRequest other = (ListInvoicesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.invoiceId, other.invoiceId) && Objects.equals(this.type, other.type) && Objects.equals(this.searchText, other.searchText) && Objects.equals(this.timeInvoiceStart, other.timeInvoiceStart) && Objects.equals(this.timeInvoiceEnd, other.timeInvoiceEnd) && Objects.equals(this.timePaymentStart, other.timePaymentStart) && Objects.equals(this.timePaymentEnd, other.timePaymentEnd) && Objects.equals(this.status, other.status) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.invoiceId == null ? 43 : this.invoiceId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.searchText == null ? 43 : this.searchText.hashCode());
        result = result * 59 + (this.timeInvoiceStart == null ? 43 : this.timeInvoiceStart.hashCode());
        result = result * 59 + (this.timeInvoiceEnd == null ? 43 : this.timeInvoiceEnd.hashCode());
        result = result * 59 + (this.timePaymentStart == null ? 43 : this.timePaymentStart.hashCode());
        result = result * 59 + (this.timePaymentEnd == null ? 43 : this.timePaymentEnd.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListInvoicesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ospHomeRegion = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private String invoiceId = null;
        private List<Type> type = null;
        private String searchText = null;
        private Date timeInvoiceStart = null;
        private Date timeInvoiceEnd = null;
        private Date timePaymentStart = null;
        private Date timePaymentEnd = null;
        private List<Status> status = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder type(List<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type singularValue) {
            return this.type(Arrays.asList(singularValue));
        }

        public Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public Builder timeInvoiceStart(Date timeInvoiceStart) {
            this.timeInvoiceStart = timeInvoiceStart;
            return this;
        }

        public Builder timeInvoiceEnd(Date timeInvoiceEnd) {
            this.timeInvoiceEnd = timeInvoiceEnd;
            return this;
        }

        public Builder timePaymentStart(Date timePaymentStart) {
            this.timePaymentStart = timePaymentStart;
            return this;
        }

        public Builder timePaymentEnd(Date timePaymentEnd) {
            this.timePaymentEnd = timePaymentEnd;
            return this;
        }

        public Builder status(List<Status> status) {
            this.status = status;
            return this;
        }

        public Builder status(Status singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInvoicesRequest o) {
            this.ospHomeRegion(o.getOspHomeRegion());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invoiceId(o.getInvoiceId());
            this.type(o.getType());
            this.searchText(o.getSearchText());
            this.timeInvoiceStart(o.getTimeInvoiceStart());
            this.timeInvoiceEnd(o.getTimeInvoiceEnd());
            this.timePaymentStart(o.getTimePaymentStart());
            this.timePaymentEnd(o.getTimePaymentEnd());
            this.status(o.getStatus());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInvoicesRequest build() {
            ListInvoicesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListInvoicesRequest buildWithoutInvocationCallback() {
            ListInvoicesRequest request = new ListInvoicesRequest();
            request.ospHomeRegion = this.ospHomeRegion;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.invoiceId = this.invoiceId;
            request.type = this.type;
            request.searchText = this.searchText;
            request.timeInvoiceStart = this.timeInvoiceStart;
            request.timeInvoiceEnd = this.timeInvoiceEnd;
            request.timePaymentStart = this.timePaymentStart;
            request.timePaymentEnd = this.timePaymentEnd;
            request.status = this.status;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        InvoiceNo("INVOICE_NO"),
        RefNo("REF_NO"),
        Status("STATUS"),
        Type("TYPE"),
        InvoiceDate("INVOICE_DATE"),
        DueDate("DUE_DATE"),
        PaymRef("PAYM_REF"),
        TotalAmount("TOTAL_AMOUNT"),
        BalanceDue("BALANCE_DUE");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Open("OPEN"),
        PastDue("PAST_DUE"),
        PaymentSubmitted("PAYMENT_SUBMITTED"),
        Closed("CLOSED");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Hardware("HARDWARE"),
        Subscription("SUBSCRIPTION"),
        Support("SUPPORT"),
        License("LICENSE"),
        Education("EDUCATION"),
        Consulting("CONSULTING"),
        Service("SERVICE"),
        Usage("USAGE");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

