/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInvoiceRequest
extends BmcRequest<Void> {
    private String ospHomeRegion;
    private String compartmentId;
    private String internalInvoiceId;
    private String opcRequestId;

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInternalInvoiceId() {
        return this.internalInvoiceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().ospHomeRegion(this.ospHomeRegion).compartmentId(this.compartmentId).internalInvoiceId(this.internalInvoiceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",internalInvoiceId=").append(String.valueOf(this.internalInvoiceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInvoiceRequest)) {
            return false;
        }
        GetInvoiceRequest other = (GetInvoiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.internalInvoiceId, other.internalInvoiceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.internalInvoiceId == null ? 43 : this.internalInvoiceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInvoiceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ospHomeRegion = null;
        private String compartmentId = null;
        private String internalInvoiceId = null;
        private String opcRequestId = null;

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder internalInvoiceId(String internalInvoiceId) {
            this.internalInvoiceId = internalInvoiceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInvoiceRequest o) {
            this.ospHomeRegion(o.getOspHomeRegion());
            this.compartmentId(o.getCompartmentId());
            this.internalInvoiceId(o.getInternalInvoiceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInvoiceRequest build() {
            GetInvoiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInvoiceRequest buildWithoutInvocationCallback() {
            GetInvoiceRequest request = new GetInvoiceRequest();
            request.ospHomeRegion = this.ospHomeRegion;
            request.compartmentId = this.compartmentId;
            request.internalInvoiceId = this.internalInvoiceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

