/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ospgateway.model.PaymentOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod")
@JsonFilter(value="explicitlySetFilter")
public final class PaypalPaymentOption
extends PaymentOption {
    @JsonProperty(value="emailAddress")
    private final String emailAddress;
    @JsonProperty(value="firstName")
    private final String firstName;
    @JsonProperty(value="lastName")
    private final String lastName;
    @JsonProperty(value="extBillingAgreementId")
    private final String extBillingAgreementId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PaypalPaymentOption(String walletInstrumentId, String walletTransactionId, String emailAddress, String firstName, String lastName, String extBillingAgreementId) {
        super(walletInstrumentId, walletTransactionId);
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.extBillingAgreementId = extBillingAgreementId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getExtBillingAgreementId() {
        return this.extBillingAgreementId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PaypalPaymentOption(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", emailAddress=").append(String.valueOf(this.emailAddress));
        sb.append(", firstName=").append(String.valueOf(this.firstName));
        sb.append(", lastName=").append(String.valueOf(this.lastName));
        sb.append(", extBillingAgreementId=").append(String.valueOf(this.extBillingAgreementId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaypalPaymentOption)) {
            return false;
        }
        PaypalPaymentOption other = (PaypalPaymentOption)((Object)o);
        return Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.extBillingAgreementId, other.extBillingAgreementId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.emailAddress == null ? 43 : this.emailAddress.hashCode());
        result = result * 59 + (this.firstName == null ? 43 : this.firstName.hashCode());
        result = result * 59 + (this.lastName == null ? 43 : this.lastName.hashCode());
        result = result * 59 + (this.extBillingAgreementId == null ? 43 : this.extBillingAgreementId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="walletInstrumentId")
        private String walletInstrumentId;
        @JsonProperty(value="walletTransactionId")
        private String walletTransactionId;
        @JsonProperty(value="emailAddress")
        private String emailAddress;
        @JsonProperty(value="firstName")
        private String firstName;
        @JsonProperty(value="lastName")
        private String lastName;
        @JsonProperty(value="extBillingAgreementId")
        private String extBillingAgreementId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder walletInstrumentId(String walletInstrumentId) {
            this.walletInstrumentId = walletInstrumentId;
            this.__explicitlySet__.add("walletInstrumentId");
            return this;
        }

        public Builder walletTransactionId(String walletTransactionId) {
            this.walletTransactionId = walletTransactionId;
            this.__explicitlySet__.add("walletTransactionId");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.__explicitlySet__.add("emailAddress");
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            this.__explicitlySet__.add("firstName");
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            this.__explicitlySet__.add("lastName");
            return this;
        }

        public Builder extBillingAgreementId(String extBillingAgreementId) {
            this.extBillingAgreementId = extBillingAgreementId;
            this.__explicitlySet__.add("extBillingAgreementId");
            return this;
        }

        public PaypalPaymentOption build() {
            PaypalPaymentOption model = new PaypalPaymentOption(this.walletInstrumentId, this.walletTransactionId, this.emailAddress, this.firstName, this.lastName, this.extBillingAgreementId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PaypalPaymentOption model) {
            if (model.wasPropertyExplicitlySet("walletInstrumentId")) {
                this.walletInstrumentId(model.getWalletInstrumentId());
            }
            if (model.wasPropertyExplicitlySet("walletTransactionId")) {
                this.walletTransactionId(model.getWalletTransactionId());
            }
            if (model.wasPropertyExplicitlySet("emailAddress")) {
                this.emailAddress(model.getEmailAddress());
            }
            if (model.wasPropertyExplicitlySet("firstName")) {
                this.firstName(model.getFirstName());
            }
            if (model.wasPropertyExplicitlySet("lastName")) {
                this.lastName(model.getLastName());
            }
            if (model.wasPropertyExplicitlySet("extBillingAgreementId")) {
                this.extBillingAgreementId(model.getExtBillingAgreementId());
            }
            return this;
        }
    }
}

