/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PaymentMethod implements BmcEnum
{
    CreditCard("CREDIT_CARD"),
    Paypal("PAYPAL"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, PaymentMethod> map;

    private PaymentMethod(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static PaymentMethod create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'PaymentMethod', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(PaymentMethod.class);
        map = new HashMap<String, PaymentMethod>();
        for (PaymentMethod v : PaymentMethod.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

