/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.Currency;
import com.oracle.bmc.ospgateway.model.PaymentDetail;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InvoiceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="invoiceId")
    private final String invoiceId;
    @JsonProperty(value="invoiceNumber")
    private final String invoiceNumber;
    @JsonProperty(value="internalInvoiceId")
    private final String internalInvoiceId;
    @JsonProperty(value="isCreditCardPayable")
    private final Boolean isCreditCardPayable;
    @JsonProperty(value="invoiceStatus")
    private final InvoiceStatus invoiceStatus;
    @JsonProperty(value="invoiceType")
    private final InvoiceType invoiceType;
    @JsonProperty(value="isPaid")
    private final Boolean isPaid;
    @JsonProperty(value="isPayable")
    private final Boolean isPayable;
    @JsonProperty(value="invoiceAmount")
    private final BigDecimal invoiceAmount;
    @JsonProperty(value="invoiceAmountDue")
    private final BigDecimal invoiceAmountDue;
    @JsonProperty(value="invoiceAmountCredited")
    private final BigDecimal invoiceAmountCredited;
    @JsonProperty(value="invoiceAmountAdjusted")
    private final BigDecimal invoiceAmountAdjusted;
    @JsonProperty(value="invoiceAmountApplied")
    private final BigDecimal invoiceAmountApplied;
    @JsonProperty(value="timeInvoiceDue")
    private final Date timeInvoiceDue;
    @JsonProperty(value="isPaymentFailed")
    private final Boolean isPaymentFailed;
    @JsonProperty(value="invoiceAmountInDispute")
    private final BigDecimal invoiceAmountInDispute;
    @JsonProperty(value="invoiceRefNumber")
    private final String invoiceRefNumber;
    @JsonProperty(value="invoicePoNumber")
    private final String invoicePoNumber;
    @JsonProperty(value="timeInvoice")
    private final Date timeInvoice;
    @JsonProperty(value="currency")
    private final Currency currency;
    @JsonProperty(value="isPdfEmailAvailable")
    private final Boolean isPdfEmailAvailable;
    @JsonProperty(value="isDisplayViewPdf")
    private final Boolean isDisplayViewPdf;
    @JsonProperty(value="isDisplayDownloadPdf")
    private final Boolean isDisplayDownloadPdf;
    @JsonProperty(value="lastPaymentDetail")
    private final PaymentDetail lastPaymentDetail;
    @JsonProperty(value="partyName")
    private final String partyName;
    @JsonProperty(value="subscriptionIds")
    private final List<String> subscriptionIds;

    @Deprecated
    @ConstructorProperties(value={"invoiceId", "invoiceNumber", "internalInvoiceId", "isCreditCardPayable", "invoiceStatus", "invoiceType", "isPaid", "isPayable", "invoiceAmount", "invoiceAmountDue", "invoiceAmountCredited", "invoiceAmountAdjusted", "invoiceAmountApplied", "timeInvoiceDue", "isPaymentFailed", "invoiceAmountInDispute", "invoiceRefNumber", "invoicePoNumber", "timeInvoice", "currency", "isPdfEmailAvailable", "isDisplayViewPdf", "isDisplayDownloadPdf", "lastPaymentDetail", "partyName", "subscriptionIds"})
    public InvoiceSummary(String invoiceId, String invoiceNumber, String internalInvoiceId, Boolean isCreditCardPayable, InvoiceStatus invoiceStatus, InvoiceType invoiceType, Boolean isPaid, Boolean isPayable, BigDecimal invoiceAmount, BigDecimal invoiceAmountDue, BigDecimal invoiceAmountCredited, BigDecimal invoiceAmountAdjusted, BigDecimal invoiceAmountApplied, Date timeInvoiceDue, Boolean isPaymentFailed, BigDecimal invoiceAmountInDispute, String invoiceRefNumber, String invoicePoNumber, Date timeInvoice, Currency currency, Boolean isPdfEmailAvailable, Boolean isDisplayViewPdf, Boolean isDisplayDownloadPdf, PaymentDetail lastPaymentDetail, String partyName, List<String> subscriptionIds) {
        this.invoiceId = invoiceId;
        this.invoiceNumber = invoiceNumber;
        this.internalInvoiceId = internalInvoiceId;
        this.isCreditCardPayable = isCreditCardPayable;
        this.invoiceStatus = invoiceStatus;
        this.invoiceType = invoiceType;
        this.isPaid = isPaid;
        this.isPayable = isPayable;
        this.invoiceAmount = invoiceAmount;
        this.invoiceAmountDue = invoiceAmountDue;
        this.invoiceAmountCredited = invoiceAmountCredited;
        this.invoiceAmountAdjusted = invoiceAmountAdjusted;
        this.invoiceAmountApplied = invoiceAmountApplied;
        this.timeInvoiceDue = timeInvoiceDue;
        this.isPaymentFailed = isPaymentFailed;
        this.invoiceAmountInDispute = invoiceAmountInDispute;
        this.invoiceRefNumber = invoiceRefNumber;
        this.invoicePoNumber = invoicePoNumber;
        this.timeInvoice = timeInvoice;
        this.currency = currency;
        this.isPdfEmailAvailable = isPdfEmailAvailable;
        this.isDisplayViewPdf = isDisplayViewPdf;
        this.isDisplayDownloadPdf = isDisplayDownloadPdf;
        this.lastPaymentDetail = lastPaymentDetail;
        this.partyName = partyName;
        this.subscriptionIds = subscriptionIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getInternalInvoiceId() {
        return this.internalInvoiceId;
    }

    public Boolean getIsCreditCardPayable() {
        return this.isCreditCardPayable;
    }

    public InvoiceStatus getInvoiceStatus() {
        return this.invoiceStatus;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public Boolean getIsPaid() {
        return this.isPaid;
    }

    public Boolean getIsPayable() {
        return this.isPayable;
    }

    public BigDecimal getInvoiceAmount() {
        return this.invoiceAmount;
    }

    public BigDecimal getInvoiceAmountDue() {
        return this.invoiceAmountDue;
    }

    public BigDecimal getInvoiceAmountCredited() {
        return this.invoiceAmountCredited;
    }

    public BigDecimal getInvoiceAmountAdjusted() {
        return this.invoiceAmountAdjusted;
    }

    public BigDecimal getInvoiceAmountApplied() {
        return this.invoiceAmountApplied;
    }

    public Date getTimeInvoiceDue() {
        return this.timeInvoiceDue;
    }

    public Boolean getIsPaymentFailed() {
        return this.isPaymentFailed;
    }

    public BigDecimal getInvoiceAmountInDispute() {
        return this.invoiceAmountInDispute;
    }

    public String getInvoiceRefNumber() {
        return this.invoiceRefNumber;
    }

    public String getInvoicePoNumber() {
        return this.invoicePoNumber;
    }

    public Date getTimeInvoice() {
        return this.timeInvoice;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Boolean getIsPdfEmailAvailable() {
        return this.isPdfEmailAvailable;
    }

    public Boolean getIsDisplayViewPdf() {
        return this.isDisplayViewPdf;
    }

    public Boolean getIsDisplayDownloadPdf() {
        return this.isDisplayDownloadPdf;
    }

    public PaymentDetail getLastPaymentDetail() {
        return this.lastPaymentDetail;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoiceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("invoiceId=").append(String.valueOf(this.invoiceId));
        sb.append(", invoiceNumber=").append(String.valueOf(this.invoiceNumber));
        sb.append(", internalInvoiceId=").append(String.valueOf(this.internalInvoiceId));
        sb.append(", isCreditCardPayable=").append(String.valueOf(this.isCreditCardPayable));
        sb.append(", invoiceStatus=").append(String.valueOf((Object)this.invoiceStatus));
        sb.append(", invoiceType=").append(String.valueOf((Object)this.invoiceType));
        sb.append(", isPaid=").append(String.valueOf(this.isPaid));
        sb.append(", isPayable=").append(String.valueOf(this.isPayable));
        sb.append(", invoiceAmount=").append(String.valueOf(this.invoiceAmount));
        sb.append(", invoiceAmountDue=").append(String.valueOf(this.invoiceAmountDue));
        sb.append(", invoiceAmountCredited=").append(String.valueOf(this.invoiceAmountCredited));
        sb.append(", invoiceAmountAdjusted=").append(String.valueOf(this.invoiceAmountAdjusted));
        sb.append(", invoiceAmountApplied=").append(String.valueOf(this.invoiceAmountApplied));
        sb.append(", timeInvoiceDue=").append(String.valueOf(this.timeInvoiceDue));
        sb.append(", isPaymentFailed=").append(String.valueOf(this.isPaymentFailed));
        sb.append(", invoiceAmountInDispute=").append(String.valueOf(this.invoiceAmountInDispute));
        sb.append(", invoiceRefNumber=").append(String.valueOf(this.invoiceRefNumber));
        sb.append(", invoicePoNumber=").append(String.valueOf(this.invoicePoNumber));
        sb.append(", timeInvoice=").append(String.valueOf(this.timeInvoice));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(", isPdfEmailAvailable=").append(String.valueOf(this.isPdfEmailAvailable));
        sb.append(", isDisplayViewPdf=").append(String.valueOf(this.isDisplayViewPdf));
        sb.append(", isDisplayDownloadPdf=").append(String.valueOf(this.isDisplayDownloadPdf));
        sb.append(", lastPaymentDetail=").append(String.valueOf((Object)this.lastPaymentDetail));
        sb.append(", partyName=").append(String.valueOf(this.partyName));
        sb.append(", subscriptionIds=").append(String.valueOf(this.subscriptionIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoiceSummary)) {
            return false;
        }
        InvoiceSummary other = (InvoiceSummary)((Object)o);
        return Objects.equals(this.invoiceId, other.invoiceId) && Objects.equals(this.invoiceNumber, other.invoiceNumber) && Objects.equals(this.internalInvoiceId, other.internalInvoiceId) && Objects.equals(this.isCreditCardPayable, other.isCreditCardPayable) && Objects.equals((Object)this.invoiceStatus, (Object)other.invoiceStatus) && Objects.equals((Object)this.invoiceType, (Object)other.invoiceType) && Objects.equals(this.isPaid, other.isPaid) && Objects.equals(this.isPayable, other.isPayable) && Objects.equals(this.invoiceAmount, other.invoiceAmount) && Objects.equals(this.invoiceAmountDue, other.invoiceAmountDue) && Objects.equals(this.invoiceAmountCredited, other.invoiceAmountCredited) && Objects.equals(this.invoiceAmountAdjusted, other.invoiceAmountAdjusted) && Objects.equals(this.invoiceAmountApplied, other.invoiceAmountApplied) && Objects.equals(this.timeInvoiceDue, other.timeInvoiceDue) && Objects.equals(this.isPaymentFailed, other.isPaymentFailed) && Objects.equals(this.invoiceAmountInDispute, other.invoiceAmountInDispute) && Objects.equals(this.invoiceRefNumber, other.invoiceRefNumber) && Objects.equals(this.invoicePoNumber, other.invoicePoNumber) && Objects.equals(this.timeInvoice, other.timeInvoice) && Objects.equals((Object)this.currency, (Object)other.currency) && Objects.equals(this.isPdfEmailAvailable, other.isPdfEmailAvailable) && Objects.equals(this.isDisplayViewPdf, other.isDisplayViewPdf) && Objects.equals(this.isDisplayDownloadPdf, other.isDisplayDownloadPdf) && Objects.equals((Object)this.lastPaymentDetail, (Object)other.lastPaymentDetail) && Objects.equals(this.partyName, other.partyName) && Objects.equals(this.subscriptionIds, other.subscriptionIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.invoiceId == null ? 43 : this.invoiceId.hashCode());
        result = result * 59 + (this.invoiceNumber == null ? 43 : this.invoiceNumber.hashCode());
        result = result * 59 + (this.internalInvoiceId == null ? 43 : this.internalInvoiceId.hashCode());
        result = result * 59 + (this.isCreditCardPayable == null ? 43 : this.isCreditCardPayable.hashCode());
        result = result * 59 + (this.invoiceStatus == null ? 43 : this.invoiceStatus.hashCode());
        result = result * 59 + (this.invoiceType == null ? 43 : this.invoiceType.hashCode());
        result = result * 59 + (this.isPaid == null ? 43 : this.isPaid.hashCode());
        result = result * 59 + (this.isPayable == null ? 43 : this.isPayable.hashCode());
        result = result * 59 + (this.invoiceAmount == null ? 43 : this.invoiceAmount.hashCode());
        result = result * 59 + (this.invoiceAmountDue == null ? 43 : this.invoiceAmountDue.hashCode());
        result = result * 59 + (this.invoiceAmountCredited == null ? 43 : this.invoiceAmountCredited.hashCode());
        result = result * 59 + (this.invoiceAmountAdjusted == null ? 43 : this.invoiceAmountAdjusted.hashCode());
        result = result * 59 + (this.invoiceAmountApplied == null ? 43 : this.invoiceAmountApplied.hashCode());
        result = result * 59 + (this.timeInvoiceDue == null ? 43 : this.timeInvoiceDue.hashCode());
        result = result * 59 + (this.isPaymentFailed == null ? 43 : this.isPaymentFailed.hashCode());
        result = result * 59 + (this.invoiceAmountInDispute == null ? 43 : this.invoiceAmountInDispute.hashCode());
        result = result * 59 + (this.invoiceRefNumber == null ? 43 : this.invoiceRefNumber.hashCode());
        result = result * 59 + (this.invoicePoNumber == null ? 43 : this.invoicePoNumber.hashCode());
        result = result * 59 + (this.timeInvoice == null ? 43 : this.timeInvoice.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.isPdfEmailAvailable == null ? 43 : this.isPdfEmailAvailable.hashCode());
        result = result * 59 + (this.isDisplayViewPdf == null ? 43 : this.isDisplayViewPdf.hashCode());
        result = result * 59 + (this.isDisplayDownloadPdf == null ? 43 : this.isDisplayDownloadPdf.hashCode());
        result = result * 59 + (this.lastPaymentDetail == null ? 43 : this.lastPaymentDetail.hashCode());
        result = result * 59 + (this.partyName == null ? 43 : this.partyName.hashCode());
        result = result * 59 + (this.subscriptionIds == null ? 43 : this.subscriptionIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InvoiceType implements BmcEnum
    {
        Hardware("HARDWARE"),
        Subscription("SUBSCRIPTION"),
        Support("SUPPORT"),
        License("LICENSE"),
        Education("EDUCATION"),
        Consulting("CONSULTING"),
        Service("SERVICE"),
        Usage("USAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InvoiceType> map;

        private InvoiceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InvoiceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InvoiceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InvoiceType.class);
            map = new HashMap<String, InvoiceType>();
            for (InvoiceType v : InvoiceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InvoiceStatus implements BmcEnum
    {
        Open("OPEN"),
        PastDue("PAST_DUE"),
        PaymentSubmitted("PAYMENT_SUBMITTED"),
        Closed("CLOSED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InvoiceStatus> map;

        private InvoiceStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InvoiceStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InvoiceStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InvoiceStatus.class);
            map = new HashMap<String, InvoiceStatus>();
            for (InvoiceStatus v : InvoiceStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="invoiceId")
        private String invoiceId;
        @JsonProperty(value="invoiceNumber")
        private String invoiceNumber;
        @JsonProperty(value="internalInvoiceId")
        private String internalInvoiceId;
        @JsonProperty(value="isCreditCardPayable")
        private Boolean isCreditCardPayable;
        @JsonProperty(value="invoiceStatus")
        private InvoiceStatus invoiceStatus;
        @JsonProperty(value="invoiceType")
        private InvoiceType invoiceType;
        @JsonProperty(value="isPaid")
        private Boolean isPaid;
        @JsonProperty(value="isPayable")
        private Boolean isPayable;
        @JsonProperty(value="invoiceAmount")
        private BigDecimal invoiceAmount;
        @JsonProperty(value="invoiceAmountDue")
        private BigDecimal invoiceAmountDue;
        @JsonProperty(value="invoiceAmountCredited")
        private BigDecimal invoiceAmountCredited;
        @JsonProperty(value="invoiceAmountAdjusted")
        private BigDecimal invoiceAmountAdjusted;
        @JsonProperty(value="invoiceAmountApplied")
        private BigDecimal invoiceAmountApplied;
        @JsonProperty(value="timeInvoiceDue")
        private Date timeInvoiceDue;
        @JsonProperty(value="isPaymentFailed")
        private Boolean isPaymentFailed;
        @JsonProperty(value="invoiceAmountInDispute")
        private BigDecimal invoiceAmountInDispute;
        @JsonProperty(value="invoiceRefNumber")
        private String invoiceRefNumber;
        @JsonProperty(value="invoicePoNumber")
        private String invoicePoNumber;
        @JsonProperty(value="timeInvoice")
        private Date timeInvoice;
        @JsonProperty(value="currency")
        private Currency currency;
        @JsonProperty(value="isPdfEmailAvailable")
        private Boolean isPdfEmailAvailable;
        @JsonProperty(value="isDisplayViewPdf")
        private Boolean isDisplayViewPdf;
        @JsonProperty(value="isDisplayDownloadPdf")
        private Boolean isDisplayDownloadPdf;
        @JsonProperty(value="lastPaymentDetail")
        private PaymentDetail lastPaymentDetail;
        @JsonProperty(value="partyName")
        private String partyName;
        @JsonProperty(value="subscriptionIds")
        private List<String> subscriptionIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            this.__explicitlySet__.add("invoiceId");
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            this.__explicitlySet__.add("invoiceNumber");
            return this;
        }

        public Builder internalInvoiceId(String internalInvoiceId) {
            this.internalInvoiceId = internalInvoiceId;
            this.__explicitlySet__.add("internalInvoiceId");
            return this;
        }

        public Builder isCreditCardPayable(Boolean isCreditCardPayable) {
            this.isCreditCardPayable = isCreditCardPayable;
            this.__explicitlySet__.add("isCreditCardPayable");
            return this;
        }

        public Builder invoiceStatus(InvoiceStatus invoiceStatus) {
            this.invoiceStatus = invoiceStatus;
            this.__explicitlySet__.add("invoiceStatus");
            return this;
        }

        public Builder invoiceType(InvoiceType invoiceType) {
            this.invoiceType = invoiceType;
            this.__explicitlySet__.add("invoiceType");
            return this;
        }

        public Builder isPaid(Boolean isPaid) {
            this.isPaid = isPaid;
            this.__explicitlySet__.add("isPaid");
            return this;
        }

        public Builder isPayable(Boolean isPayable) {
            this.isPayable = isPayable;
            this.__explicitlySet__.add("isPayable");
            return this;
        }

        public Builder invoiceAmount(BigDecimal invoiceAmount) {
            this.invoiceAmount = invoiceAmount;
            this.__explicitlySet__.add("invoiceAmount");
            return this;
        }

        public Builder invoiceAmountDue(BigDecimal invoiceAmountDue) {
            this.invoiceAmountDue = invoiceAmountDue;
            this.__explicitlySet__.add("invoiceAmountDue");
            return this;
        }

        public Builder invoiceAmountCredited(BigDecimal invoiceAmountCredited) {
            this.invoiceAmountCredited = invoiceAmountCredited;
            this.__explicitlySet__.add("invoiceAmountCredited");
            return this;
        }

        public Builder invoiceAmountAdjusted(BigDecimal invoiceAmountAdjusted) {
            this.invoiceAmountAdjusted = invoiceAmountAdjusted;
            this.__explicitlySet__.add("invoiceAmountAdjusted");
            return this;
        }

        public Builder invoiceAmountApplied(BigDecimal invoiceAmountApplied) {
            this.invoiceAmountApplied = invoiceAmountApplied;
            this.__explicitlySet__.add("invoiceAmountApplied");
            return this;
        }

        public Builder timeInvoiceDue(Date timeInvoiceDue) {
            this.timeInvoiceDue = timeInvoiceDue;
            this.__explicitlySet__.add("timeInvoiceDue");
            return this;
        }

        public Builder isPaymentFailed(Boolean isPaymentFailed) {
            this.isPaymentFailed = isPaymentFailed;
            this.__explicitlySet__.add("isPaymentFailed");
            return this;
        }

        public Builder invoiceAmountInDispute(BigDecimal invoiceAmountInDispute) {
            this.invoiceAmountInDispute = invoiceAmountInDispute;
            this.__explicitlySet__.add("invoiceAmountInDispute");
            return this;
        }

        public Builder invoiceRefNumber(String invoiceRefNumber) {
            this.invoiceRefNumber = invoiceRefNumber;
            this.__explicitlySet__.add("invoiceRefNumber");
            return this;
        }

        public Builder invoicePoNumber(String invoicePoNumber) {
            this.invoicePoNumber = invoicePoNumber;
            this.__explicitlySet__.add("invoicePoNumber");
            return this;
        }

        public Builder timeInvoice(Date timeInvoice) {
            this.timeInvoice = timeInvoice;
            this.__explicitlySet__.add("timeInvoice");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder isPdfEmailAvailable(Boolean isPdfEmailAvailable) {
            this.isPdfEmailAvailable = isPdfEmailAvailable;
            this.__explicitlySet__.add("isPdfEmailAvailable");
            return this;
        }

        public Builder isDisplayViewPdf(Boolean isDisplayViewPdf) {
            this.isDisplayViewPdf = isDisplayViewPdf;
            this.__explicitlySet__.add("isDisplayViewPdf");
            return this;
        }

        public Builder isDisplayDownloadPdf(Boolean isDisplayDownloadPdf) {
            this.isDisplayDownloadPdf = isDisplayDownloadPdf;
            this.__explicitlySet__.add("isDisplayDownloadPdf");
            return this;
        }

        public Builder lastPaymentDetail(PaymentDetail lastPaymentDetail) {
            this.lastPaymentDetail = lastPaymentDetail;
            this.__explicitlySet__.add("lastPaymentDetail");
            return this;
        }

        public Builder partyName(String partyName) {
            this.partyName = partyName;
            this.__explicitlySet__.add("partyName");
            return this;
        }

        public Builder subscriptionIds(List<String> subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            this.__explicitlySet__.add("subscriptionIds");
            return this;
        }

        public InvoiceSummary build() {
            InvoiceSummary model = new InvoiceSummary(this.invoiceId, this.invoiceNumber, this.internalInvoiceId, this.isCreditCardPayable, this.invoiceStatus, this.invoiceType, this.isPaid, this.isPayable, this.invoiceAmount, this.invoiceAmountDue, this.invoiceAmountCredited, this.invoiceAmountAdjusted, this.invoiceAmountApplied, this.timeInvoiceDue, this.isPaymentFailed, this.invoiceAmountInDispute, this.invoiceRefNumber, this.invoicePoNumber, this.timeInvoice, this.currency, this.isPdfEmailAvailable, this.isDisplayViewPdf, this.isDisplayDownloadPdf, this.lastPaymentDetail, this.partyName, this.subscriptionIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InvoiceSummary model) {
            if (model.wasPropertyExplicitlySet("invoiceId")) {
                this.invoiceId(model.getInvoiceId());
            }
            if (model.wasPropertyExplicitlySet("invoiceNumber")) {
                this.invoiceNumber(model.getInvoiceNumber());
            }
            if (model.wasPropertyExplicitlySet("internalInvoiceId")) {
                this.internalInvoiceId(model.getInternalInvoiceId());
            }
            if (model.wasPropertyExplicitlySet("isCreditCardPayable")) {
                this.isCreditCardPayable(model.getIsCreditCardPayable());
            }
            if (model.wasPropertyExplicitlySet("invoiceStatus")) {
                this.invoiceStatus(model.getInvoiceStatus());
            }
            if (model.wasPropertyExplicitlySet("invoiceType")) {
                this.invoiceType(model.getInvoiceType());
            }
            if (model.wasPropertyExplicitlySet("isPaid")) {
                this.isPaid(model.getIsPaid());
            }
            if (model.wasPropertyExplicitlySet("isPayable")) {
                this.isPayable(model.getIsPayable());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmount")) {
                this.invoiceAmount(model.getInvoiceAmount());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountDue")) {
                this.invoiceAmountDue(model.getInvoiceAmountDue());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountCredited")) {
                this.invoiceAmountCredited(model.getInvoiceAmountCredited());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountAdjusted")) {
                this.invoiceAmountAdjusted(model.getInvoiceAmountAdjusted());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountApplied")) {
                this.invoiceAmountApplied(model.getInvoiceAmountApplied());
            }
            if (model.wasPropertyExplicitlySet("timeInvoiceDue")) {
                this.timeInvoiceDue(model.getTimeInvoiceDue());
            }
            if (model.wasPropertyExplicitlySet("isPaymentFailed")) {
                this.isPaymentFailed(model.getIsPaymentFailed());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountInDispute")) {
                this.invoiceAmountInDispute(model.getInvoiceAmountInDispute());
            }
            if (model.wasPropertyExplicitlySet("invoiceRefNumber")) {
                this.invoiceRefNumber(model.getInvoiceRefNumber());
            }
            if (model.wasPropertyExplicitlySet("invoicePoNumber")) {
                this.invoicePoNumber(model.getInvoicePoNumber());
            }
            if (model.wasPropertyExplicitlySet("timeInvoice")) {
                this.timeInvoice(model.getTimeInvoice());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("isPdfEmailAvailable")) {
                this.isPdfEmailAvailable(model.getIsPdfEmailAvailable());
            }
            if (model.wasPropertyExplicitlySet("isDisplayViewPdf")) {
                this.isDisplayViewPdf(model.getIsDisplayViewPdf());
            }
            if (model.wasPropertyExplicitlySet("isDisplayDownloadPdf")) {
                this.isDisplayDownloadPdf(model.getIsDisplayDownloadPdf());
            }
            if (model.wasPropertyExplicitlySet("lastPaymentDetail")) {
                this.lastPaymentDetail(model.getLastPaymentDetail());
            }
            if (model.wasPropertyExplicitlySet("partyName")) {
                this.partyName(model.getPartyName());
            }
            if (model.wasPropertyExplicitlySet("subscriptionIds")) {
                this.subscriptionIds(model.getSubscriptionIds());
            }
            return this;
        }
    }
}

