/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ospgateway.model.Currency;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InvoiceLineSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="product")
    private final String product;
    @JsonProperty(value="orderNo")
    private final String orderNo;
    @JsonProperty(value="partNumber")
    private final String partNumber;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="quantity")
    private final BigDecimal quantity;
    @JsonProperty(value="netUnitPrice")
    private final BigDecimal netUnitPrice;
    @JsonProperty(value="totalPrice")
    private final BigDecimal totalPrice;
    @JsonProperty(value="currency")
    private final Currency currency;

    @Deprecated
    @ConstructorProperties(value={"product", "orderNo", "partNumber", "timeStart", "timeEnd", "quantity", "netUnitPrice", "totalPrice", "currency"})
    public InvoiceLineSummary(String product, String orderNo, String partNumber, Date timeStart, Date timeEnd, BigDecimal quantity, BigDecimal netUnitPrice, BigDecimal totalPrice, Currency currency) {
        this.product = product;
        this.orderNo = orderNo;
        this.partNumber = partNumber;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.quantity = quantity;
        this.netUnitPrice = netUnitPrice;
        this.totalPrice = totalPrice;
        this.currency = currency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProduct() {
        return this.product;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getNetUnitPrice() {
        return this.netUnitPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoiceLineSummary(");
        sb.append("super=").append(super.toString());
        sb.append("product=").append(String.valueOf(this.product));
        sb.append(", orderNo=").append(String.valueOf(this.orderNo));
        sb.append(", partNumber=").append(String.valueOf(this.partNumber));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", netUnitPrice=").append(String.valueOf(this.netUnitPrice));
        sb.append(", totalPrice=").append(String.valueOf(this.totalPrice));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoiceLineSummary)) {
            return false;
        }
        InvoiceLineSummary other = (InvoiceLineSummary)((Object)o);
        return Objects.equals(this.product, other.product) && Objects.equals(this.orderNo, other.orderNo) && Objects.equals(this.partNumber, other.partNumber) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.netUnitPrice, other.netUnitPrice) && Objects.equals(this.totalPrice, other.totalPrice) && Objects.equals((Object)this.currency, (Object)other.currency) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.orderNo == null ? 43 : this.orderNo.hashCode());
        result = result * 59 + (this.partNumber == null ? 43 : this.partNumber.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.netUnitPrice == null ? 43 : this.netUnitPrice.hashCode());
        result = result * 59 + (this.totalPrice == null ? 43 : this.totalPrice.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="product")
        private String product;
        @JsonProperty(value="orderNo")
        private String orderNo;
        @JsonProperty(value="partNumber")
        private String partNumber;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="quantity")
        private BigDecimal quantity;
        @JsonProperty(value="netUnitPrice")
        private BigDecimal netUnitPrice;
        @JsonProperty(value="totalPrice")
        private BigDecimal totalPrice;
        @JsonProperty(value="currency")
        private Currency currency;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder product(String product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            this.__explicitlySet__.add("orderNo");
            return this;
        }

        public Builder partNumber(String partNumber) {
            this.partNumber = partNumber;
            this.__explicitlySet__.add("partNumber");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder quantity(BigDecimal quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder netUnitPrice(BigDecimal netUnitPrice) {
            this.netUnitPrice = netUnitPrice;
            this.__explicitlySet__.add("netUnitPrice");
            return this;
        }

        public Builder totalPrice(BigDecimal totalPrice) {
            this.totalPrice = totalPrice;
            this.__explicitlySet__.add("totalPrice");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public InvoiceLineSummary build() {
            InvoiceLineSummary model = new InvoiceLineSummary(this.product, this.orderNo, this.partNumber, this.timeStart, this.timeEnd, this.quantity, this.netUnitPrice, this.totalPrice, this.currency);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InvoiceLineSummary model) {
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("orderNo")) {
                this.orderNo(model.getOrderNo());
            }
            if (model.wasPropertyExplicitlySet("partNumber")) {
                this.partNumber(model.getPartNumber());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("netUnitPrice")) {
                this.netUnitPrice(model.getNetUnitPrice());
            }
            if (model.wasPropertyExplicitlySet("totalPrice")) {
                this.totalPrice(model.getTotalPrice());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            return this;
        }
    }
}

