/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.PaymentDetail;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod")
@JsonFilter(value="explicitlySetFilter")
public final class CreditCardPaymentDetail
extends PaymentDetail {
    @JsonProperty(value="nameOnCard")
    private final String nameOnCard;
    @JsonProperty(value="creditCardType")
    private final CreditCardType creditCardType;
    @JsonProperty(value="lastDigits")
    private final String lastDigits;
    @JsonProperty(value="timeExpiration")
    private final Date timeExpiration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreditCardPaymentDetail(Date timePaidOn, String paidBy, BigDecimal amountPaid, String nameOnCard, CreditCardType creditCardType, String lastDigits, Date timeExpiration) {
        super(timePaidOn, paidBy, amountPaid);
        this.nameOnCard = nameOnCard;
        this.creditCardType = creditCardType;
        this.lastDigits = lastDigits;
        this.timeExpiration = timeExpiration;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public CreditCardType getCreditCardType() {
        return this.creditCardType;
    }

    public String getLastDigits() {
        return this.lastDigits;
    }

    public Date getTimeExpiration() {
        return this.timeExpiration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreditCardPaymentDetail(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", nameOnCard=").append(String.valueOf(this.nameOnCard));
        sb.append(", creditCardType=").append(String.valueOf((Object)this.creditCardType));
        sb.append(", lastDigits=").append(String.valueOf(this.lastDigits));
        sb.append(", timeExpiration=").append(String.valueOf(this.timeExpiration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreditCardPaymentDetail)) {
            return false;
        }
        CreditCardPaymentDetail other = (CreditCardPaymentDetail)((Object)o);
        return Objects.equals(this.nameOnCard, other.nameOnCard) && Objects.equals((Object)this.creditCardType, (Object)other.creditCardType) && Objects.equals(this.lastDigits, other.lastDigits) && Objects.equals(this.timeExpiration, other.timeExpiration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.nameOnCard == null ? 43 : this.nameOnCard.hashCode());
        result = result * 59 + (this.creditCardType == null ? 43 : this.creditCardType.hashCode());
        result = result * 59 + (this.lastDigits == null ? 43 : this.lastDigits.hashCode());
        result = result * 59 + (this.timeExpiration == null ? 43 : this.timeExpiration.hashCode());
        return result;
    }

    public static enum CreditCardType implements BmcEnum
    {
        Visa("VISA"),
        Amex("AMEX"),
        Mastercard("MASTERCARD"),
        Discover("DISCOVER"),
        Jcb("JCB"),
        Diner("DINER"),
        Elo("ELO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CreditCardType> map;

        private CreditCardType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CreditCardType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CreditCardType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CreditCardType.class);
            map = new HashMap<String, CreditCardType>();
            for (CreditCardType v : CreditCardType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timePaidOn")
        private Date timePaidOn;
        @JsonProperty(value="paidBy")
        private String paidBy;
        @JsonProperty(value="amountPaid")
        private BigDecimal amountPaid;
        @JsonProperty(value="nameOnCard")
        private String nameOnCard;
        @JsonProperty(value="creditCardType")
        private CreditCardType creditCardType;
        @JsonProperty(value="lastDigits")
        private String lastDigits;
        @JsonProperty(value="timeExpiration")
        private Date timeExpiration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timePaidOn(Date timePaidOn) {
            this.timePaidOn = timePaidOn;
            this.__explicitlySet__.add("timePaidOn");
            return this;
        }

        public Builder paidBy(String paidBy) {
            this.paidBy = paidBy;
            this.__explicitlySet__.add("paidBy");
            return this;
        }

        public Builder amountPaid(BigDecimal amountPaid) {
            this.amountPaid = amountPaid;
            this.__explicitlySet__.add("amountPaid");
            return this;
        }

        public Builder nameOnCard(String nameOnCard) {
            this.nameOnCard = nameOnCard;
            this.__explicitlySet__.add("nameOnCard");
            return this;
        }

        public Builder creditCardType(CreditCardType creditCardType) {
            this.creditCardType = creditCardType;
            this.__explicitlySet__.add("creditCardType");
            return this;
        }

        public Builder lastDigits(String lastDigits) {
            this.lastDigits = lastDigits;
            this.__explicitlySet__.add("lastDigits");
            return this;
        }

        public Builder timeExpiration(Date timeExpiration) {
            this.timeExpiration = timeExpiration;
            this.__explicitlySet__.add("timeExpiration");
            return this;
        }

        public CreditCardPaymentDetail build() {
            CreditCardPaymentDetail model = new CreditCardPaymentDetail(this.timePaidOn, this.paidBy, this.amountPaid, this.nameOnCard, this.creditCardType, this.lastDigits, this.timeExpiration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreditCardPaymentDetail model) {
            if (model.wasPropertyExplicitlySet("timePaidOn")) {
                this.timePaidOn(model.getTimePaidOn());
            }
            if (model.wasPropertyExplicitlySet("paidBy")) {
                this.paidBy(model.getPaidBy());
            }
            if (model.wasPropertyExplicitlySet("amountPaid")) {
                this.amountPaid(model.getAmountPaid());
            }
            if (model.wasPropertyExplicitlySet("nameOnCard")) {
                this.nameOnCard(model.getNameOnCard());
            }
            if (model.wasPropertyExplicitlySet("creditCardType")) {
                this.creditCardType(model.getCreditCardType());
            }
            if (model.wasPropertyExplicitlySet("lastDigits")) {
                this.lastDigits(model.getLastDigits());
            }
            if (model.wasPropertyExplicitlySet("timeExpiration")) {
                this.timeExpiration(model.getTimeExpiration());
            }
            return this;
        }
    }
}

