/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway;

import com.oracle.bmc.ospgateway.InvoiceService;
import com.oracle.bmc.ospgateway.model.InvoiceLineSummary;
import com.oracle.bmc.ospgateway.model.InvoiceSummary;
import com.oracle.bmc.ospgateway.requests.ListInvoiceLinesRequest;
import com.oracle.bmc.ospgateway.requests.ListInvoicesRequest;
import com.oracle.bmc.ospgateway.responses.ListInvoiceLinesResponse;
import com.oracle.bmc.ospgateway.responses.ListInvoicesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class InvoiceServicePaginators {
    private final InvoiceService client;

    public InvoiceServicePaginators(InvoiceService client) {
        this.client = client;
    }

    public Iterable<ListInvoiceLinesResponse> listInvoiceLinesResponseIterator(final ListInvoiceLinesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInvoiceLinesRequest.Builder>(){

            @Override
            public ListInvoiceLinesRequest.Builder get() {
                return ListInvoiceLinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInvoiceLinesResponse, String>(){

            @Override
            public String apply(ListInvoiceLinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInvoiceLinesRequest.Builder>, ListInvoiceLinesRequest>(){

            @Override
            public ListInvoiceLinesRequest apply(RequestBuilderAndToken<ListInvoiceLinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInvoiceLinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInvoiceLinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInvoiceLinesRequest, ListInvoiceLinesResponse>(){

            @Override
            public ListInvoiceLinesResponse apply(ListInvoiceLinesRequest request) {
                return InvoiceServicePaginators.this.client.listInvoiceLines(request);
            }
        });
    }

    public Iterable<InvoiceLineSummary> listInvoiceLinesRecordIterator(final ListInvoiceLinesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInvoiceLinesRequest.Builder>(){

            @Override
            public ListInvoiceLinesRequest.Builder get() {
                return ListInvoiceLinesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInvoiceLinesResponse, String>(){

            @Override
            public String apply(ListInvoiceLinesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInvoiceLinesRequest.Builder>, ListInvoiceLinesRequest>(){

            @Override
            public ListInvoiceLinesRequest apply(RequestBuilderAndToken<ListInvoiceLinesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInvoiceLinesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInvoiceLinesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInvoiceLinesRequest, ListInvoiceLinesResponse>(){

            @Override
            public ListInvoiceLinesResponse apply(ListInvoiceLinesRequest request) {
                return InvoiceServicePaginators.this.client.listInvoiceLines(request);
            }
        }, (Function)new Function<ListInvoiceLinesResponse, List<InvoiceLineSummary>>(){

            @Override
            public List<InvoiceLineSummary> apply(ListInvoiceLinesResponse response) {
                return response.getInvoiceLineCollection().getItems();
            }
        });
    }

    public Iterable<ListInvoicesResponse> listInvoicesResponseIterator(final ListInvoicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInvoicesRequest.Builder>(){

            @Override
            public ListInvoicesRequest.Builder get() {
                return ListInvoicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInvoicesResponse, String>(){

            @Override
            public String apply(ListInvoicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInvoicesRequest.Builder>, ListInvoicesRequest>(){

            @Override
            public ListInvoicesRequest apply(RequestBuilderAndToken<ListInvoicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInvoicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInvoicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInvoicesRequest, ListInvoicesResponse>(){

            @Override
            public ListInvoicesResponse apply(ListInvoicesRequest request) {
                return InvoiceServicePaginators.this.client.listInvoices(request);
            }
        });
    }

    public Iterable<InvoiceSummary> listInvoicesRecordIterator(final ListInvoicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInvoicesRequest.Builder>(){

            @Override
            public ListInvoicesRequest.Builder get() {
                return ListInvoicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInvoicesResponse, String>(){

            @Override
            public String apply(ListInvoicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInvoicesRequest.Builder>, ListInvoicesRequest>(){

            @Override
            public ListInvoicesRequest apply(RequestBuilderAndToken<ListInvoicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInvoicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInvoicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInvoicesRequest, ListInvoicesResponse>(){

            @Override
            public ListInvoicesResponse apply(ListInvoicesRequest request) {
                return InvoiceServicePaginators.this.client.listInvoices(request);
            }
        }, (Function)new Function<ListInvoicesResponse, List<InvoiceSummary>>(){

            @Override
            public List<InvoiceSummary> apply(ListInvoicesResponse response) {
                return response.getInvoiceCollection().getItems();
            }
        });
    }
}

