/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.SoftwarePackageDependency;
import com.oracle.bmc.osmanagement.model.SoftwarePackageFile;
import com.oracle.bmc.osmanagement.model.SoftwareSourceId;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SoftwarePackage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="lastModifiedDate")
    private final String lastModifiedDate;
    @JsonProperty(value="checksum")
    private final String checksum;
    @JsonProperty(value="checksumType")
    private final String checksumType;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="dependencies")
    private final List<SoftwarePackageDependency> dependencies;
    @JsonProperty(value="files")
    private final List<SoftwarePackageFile> files;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceId> softwareSources;

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "type", "version", "architecture", "lastModifiedDate", "checksum", "checksumType", "description", "sizeInBytes", "dependencies", "files", "softwareSources"})
    public SoftwarePackage(String displayName, String name, String type, String version, String architecture, String lastModifiedDate, String checksum, String checksumType, String description, Long sizeInBytes, List<SoftwarePackageDependency> dependencies, List<SoftwarePackageFile> files, List<SoftwareSourceId> softwareSources) {
        this.displayName = displayName;
        this.name = name;
        this.type = type;
        this.version = version;
        this.architecture = architecture;
        this.lastModifiedDate = lastModifiedDate;
        this.checksum = checksum;
        this.checksumType = checksumType;
        this.description = description;
        this.sizeInBytes = sizeInBytes;
        this.dependencies = dependencies;
        this.files = files;
        this.softwareSources = softwareSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getChecksumType() {
        return this.checksumType;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public List<SoftwarePackageDependency> getDependencies() {
        return this.dependencies;
    }

    public List<SoftwarePackageFile> getFiles() {
        return this.files;
    }

    public List<SoftwareSourceId> getSoftwareSources() {
        return this.softwareSources;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwarePackage(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", lastModifiedDate=").append(String.valueOf(this.lastModifiedDate));
        sb.append(", checksum=").append(String.valueOf(this.checksum));
        sb.append(", checksumType=").append(String.valueOf(this.checksumType));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", dependencies=").append(String.valueOf(this.dependencies));
        sb.append(", files=").append(String.valueOf(this.files));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwarePackage)) {
            return false;
        }
        SoftwarePackage other = (SoftwarePackage)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.lastModifiedDate, other.lastModifiedDate) && Objects.equals(this.checksum, other.checksum) && Objects.equals(this.checksumType, other.checksumType) && Objects.equals(this.description, other.description) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.dependencies, other.dependencies) && Objects.equals(this.files, other.files) && Objects.equals(this.softwareSources, other.softwareSources) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.lastModifiedDate == null ? 43 : this.lastModifiedDate.hashCode());
        result = result * 59 + (this.checksum == null ? 43 : this.checksum.hashCode());
        result = result * 59 + (this.checksumType == null ? 43 : this.checksumType.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.dependencies == null ? 43 : this.dependencies.hashCode());
        result = result * 59 + (this.files == null ? 43 : this.files.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="lastModifiedDate")
        private String lastModifiedDate;
        @JsonProperty(value="checksum")
        private String checksum;
        @JsonProperty(value="checksumType")
        private String checksumType;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="dependencies")
        private List<SoftwarePackageDependency> dependencies;
        @JsonProperty(value="files")
        private List<SoftwarePackageFile> files;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceId> softwareSources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            this.__explicitlySet__.add("lastModifiedDate");
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            this.__explicitlySet__.add("checksum");
            return this;
        }

        public Builder checksumType(String checksumType) {
            this.checksumType = checksumType;
            this.__explicitlySet__.add("checksumType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder dependencies(List<SoftwarePackageDependency> dependencies) {
            this.dependencies = dependencies;
            this.__explicitlySet__.add("dependencies");
            return this;
        }

        public Builder files(List<SoftwarePackageFile> files) {
            this.files = files;
            this.__explicitlySet__.add("files");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceId> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public SoftwarePackage build() {
            SoftwarePackage model = new SoftwarePackage(this.displayName, this.name, this.type, this.version, this.architecture, this.lastModifiedDate, this.checksum, this.checksumType, this.description, this.sizeInBytes, this.dependencies, this.files, this.softwareSources);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SoftwarePackage model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("lastModifiedDate")) {
                this.lastModifiedDate(model.getLastModifiedDate());
            }
            if (model.wasPropertyExplicitlySet("checksum")) {
                this.checksum(model.getChecksum());
            }
            if (model.wasPropertyExplicitlySet("checksumType")) {
                this.checksumType(model.getChecksumType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("dependencies")) {
                this.dependencies(model.getDependencies());
            }
            if (model.wasPropertyExplicitlySet("files")) {
                this.files(model.getFiles());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            return this;
        }
    }
}

