/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListErrataRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String erratumId;
    private String advisoryName;
    private Date timeIssueDateStart;
    private Date timeIssueDateEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "erratumId", "advisoryName", "timeIssueDateStart", "timeIssueDateEnd", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListErrataRequest(String compartmentId, String erratumId, String advisoryName, Date timeIssueDateStart, Date timeIssueDateEnd, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.erratumId = erratumId;
        this.advisoryName = advisoryName;
        this.timeIssueDateStart = timeIssueDateStart;
        this.timeIssueDateEnd = timeIssueDateEnd;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).erratumId(this.erratumId).advisoryName(this.advisoryName).timeIssueDateStart(this.timeIssueDateStart).timeIssueDateEnd(this.timeIssueDateEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListErrataRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", erratumId=" + this.getErratumId() + ", advisoryName=" + this.getAdvisoryName() + ", timeIssueDateStart=" + this.getTimeIssueDateStart() + ", timeIssueDateEnd=" + this.getTimeIssueDateEnd() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListErrataRequest)) {
            return false;
        }
        ListErrataRequest other = (ListErrataRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$erratumId = this.getErratumId();
        String other$erratumId = other.getErratumId();
        if (this$erratumId == null ? other$erratumId != null : !this$erratumId.equals(other$erratumId)) {
            return false;
        }
        String this$advisoryName = this.getAdvisoryName();
        String other$advisoryName = other.getAdvisoryName();
        if (this$advisoryName == null ? other$advisoryName != null : !this$advisoryName.equals(other$advisoryName)) {
            return false;
        }
        Date this$timeIssueDateStart = this.getTimeIssueDateStart();
        Date other$timeIssueDateStart = other.getTimeIssueDateStart();
        if (this$timeIssueDateStart == null ? other$timeIssueDateStart != null : !((Object)this$timeIssueDateStart).equals(other$timeIssueDateStart)) {
            return false;
        }
        Date this$timeIssueDateEnd = this.getTimeIssueDateEnd();
        Date other$timeIssueDateEnd = other.getTimeIssueDateEnd();
        if (this$timeIssueDateEnd == null ? other$timeIssueDateEnd != null : !((Object)this$timeIssueDateEnd).equals(other$timeIssueDateEnd)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListErrataRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $erratumId = this.getErratumId();
        result = result * 59 + ($erratumId == null ? 43 : $erratumId.hashCode());
        String $advisoryName = this.getAdvisoryName();
        result = result * 59 + ($advisoryName == null ? 43 : $advisoryName.hashCode());
        Date $timeIssueDateStart = this.getTimeIssueDateStart();
        result = result * 59 + ($timeIssueDateStart == null ? 43 : ((Object)$timeIssueDateStart).hashCode());
        Date $timeIssueDateEnd = this.getTimeIssueDateEnd();
        result = result * 59 + ($timeIssueDateEnd == null ? 43 : ((Object)$timeIssueDateEnd).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getErratumId() {
        return this.erratumId;
    }

    public String getAdvisoryName() {
        return this.advisoryName;
    }

    public Date getTimeIssueDateStart() {
        return this.timeIssueDateStart;
    }

    public Date getTimeIssueDateEnd() {
        return this.timeIssueDateEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListErrataRequest, Void> {
        private String compartmentId;
        private String erratumId;
        private String advisoryName;
        private Date timeIssueDateStart;
        private Date timeIssueDateEnd;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListErrataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.erratumId(o.getErratumId());
            this.advisoryName(o.getAdvisoryName());
            this.timeIssueDateStart(o.getTimeIssueDateStart());
            this.timeIssueDateEnd(o.getTimeIssueDateEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListErrataRequest build() {
            ListErrataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder erratumId(String erratumId) {
            this.erratumId = erratumId;
            return this;
        }

        public Builder advisoryName(String advisoryName) {
            this.advisoryName = advisoryName;
            return this;
        }

        public Builder timeIssueDateStart(Date timeIssueDateStart) {
            this.timeIssueDateStart = timeIssueDateStart;
            return this;
        }

        public Builder timeIssueDateEnd(Date timeIssueDateEnd) {
            this.timeIssueDateEnd = timeIssueDateEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListErrataRequest buildWithoutInvocationCallback() {
            return new ListErrataRequest(this.compartmentId, this.erratumId, this.advisoryName, this.timeIssueDateStart, this.timeIssueDateEnd, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListErrataRequest.Builder(compartmentId=" + this.compartmentId + ", erratumId=" + this.erratumId + ", advisoryName=" + this.advisoryName + ", timeIssueDateStart=" + this.timeIssueDateStart + ", timeIssueDateEnd=" + this.timeIssueDateEnd + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Issuedate("ISSUEDATE"),
        Advisoryname("ADVISORYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

