/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class GetEventReportRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String compartmentId;
    private Date latestTimestampLessThan;
    private Date latestTimestampGreaterThanOrEqualTo;
    private String opcRequestId;

    @ConstructorProperties(value={"managedInstanceId", "compartmentId", "latestTimestampLessThan", "latestTimestampGreaterThanOrEqualTo", "opcRequestId"})
    GetEventReportRequest(String managedInstanceId, String compartmentId, Date latestTimestampLessThan, Date latestTimestampGreaterThanOrEqualTo, String opcRequestId) {
        this.managedInstanceId = managedInstanceId;
        this.compartmentId = compartmentId;
        this.latestTimestampLessThan = latestTimestampLessThan;
        this.latestTimestampGreaterThanOrEqualTo = latestTimestampGreaterThanOrEqualTo;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).compartmentId(this.compartmentId).latestTimestampLessThan(this.latestTimestampLessThan).latestTimestampGreaterThanOrEqualTo(this.latestTimestampGreaterThanOrEqualTo).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetEventReportRequest(super=" + super.toString() + ", managedInstanceId=" + this.getManagedInstanceId() + ", compartmentId=" + this.getCompartmentId() + ", latestTimestampLessThan=" + this.getLatestTimestampLessThan() + ", latestTimestampGreaterThanOrEqualTo=" + this.getLatestTimestampGreaterThanOrEqualTo() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEventReportRequest)) {
            return false;
        }
        GetEventReportRequest other = (GetEventReportRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$managedInstanceId = this.getManagedInstanceId();
        String other$managedInstanceId = other.getManagedInstanceId();
        if (this$managedInstanceId == null ? other$managedInstanceId != null : !this$managedInstanceId.equals(other$managedInstanceId)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        Date this$latestTimestampLessThan = this.getLatestTimestampLessThan();
        Date other$latestTimestampLessThan = other.getLatestTimestampLessThan();
        if (this$latestTimestampLessThan == null ? other$latestTimestampLessThan != null : !((Object)this$latestTimestampLessThan).equals(other$latestTimestampLessThan)) {
            return false;
        }
        Date this$latestTimestampGreaterThanOrEqualTo = this.getLatestTimestampGreaterThanOrEqualTo();
        Date other$latestTimestampGreaterThanOrEqualTo = other.getLatestTimestampGreaterThanOrEqualTo();
        if (this$latestTimestampGreaterThanOrEqualTo == null ? other$latestTimestampGreaterThanOrEqualTo != null : !((Object)this$latestTimestampGreaterThanOrEqualTo).equals(other$latestTimestampGreaterThanOrEqualTo)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetEventReportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $managedInstanceId = this.getManagedInstanceId();
        result = result * 59 + ($managedInstanceId == null ? 43 : $managedInstanceId.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        Date $latestTimestampLessThan = this.getLatestTimestampLessThan();
        result = result * 59 + ($latestTimestampLessThan == null ? 43 : ((Object)$latestTimestampLessThan).hashCode());
        Date $latestTimestampGreaterThanOrEqualTo = this.getLatestTimestampGreaterThanOrEqualTo();
        result = result * 59 + ($latestTimestampGreaterThanOrEqualTo == null ? 43 : ((Object)$latestTimestampGreaterThanOrEqualTo).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getLatestTimestampLessThan() {
        return this.latestTimestampLessThan;
    }

    public Date getLatestTimestampGreaterThanOrEqualTo() {
        return this.latestTimestampGreaterThanOrEqualTo;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEventReportRequest, Void> {
        private String managedInstanceId;
        private String compartmentId;
        private Date latestTimestampLessThan;
        private Date latestTimestampGreaterThanOrEqualTo;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEventReportRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.compartmentId(o.getCompartmentId());
            this.latestTimestampLessThan(o.getLatestTimestampLessThan());
            this.latestTimestampGreaterThanOrEqualTo(o.getLatestTimestampGreaterThanOrEqualTo());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEventReportRequest build() {
            GetEventReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder latestTimestampLessThan(Date latestTimestampLessThan) {
            this.latestTimestampLessThan = latestTimestampLessThan;
            return this;
        }

        public Builder latestTimestampGreaterThanOrEqualTo(Date latestTimestampGreaterThanOrEqualTo) {
            this.latestTimestampGreaterThanOrEqualTo = latestTimestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetEventReportRequest buildWithoutInvocationCallback() {
            return new GetEventReportRequest(this.managedInstanceId, this.compartmentId, this.latestTimestampLessThan, this.latestTimestampGreaterThanOrEqualTo, this.opcRequestId);
        }

        public String toString() {
            return "GetEventReportRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", compartmentId=" + this.compartmentId + ", latestTimestampLessThan=" + this.latestTimestampLessThan + ", latestTimestampGreaterThanOrEqualTo=" + this.latestTimestampGreaterThanOrEqualTo + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

