/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStreamProfileSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="profileName")
    private final String profileName;

    @Deprecated
    @ConstructorProperties(value={"moduleName", "streamName", "profileName"})
    public ModuleStreamProfileSummary(String moduleName, String streamName, String profileName) {
        this.moduleName = moduleName;
        this.streamName = streamName;
        this.profileName = profileName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStreamProfileSummary(");
        sb.append("super=").append(super.toString());
        sb.append("moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", streamName=").append(String.valueOf(this.streamName));
        sb.append(", profileName=").append(String.valueOf(this.profileName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStreamProfileSummary)) {
            return false;
        }
        ModuleStreamProfileSummary other = (ModuleStreamProfileSummary)((Object)o);
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.streamName, other.streamName) && Objects.equals(this.profileName, other.profileName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.profileName == null ? 43 : this.profileName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="profileName")
        private String profileName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            this.__explicitlySet__.add("profileName");
            return this;
        }

        public ModuleStreamProfileSummary build() {
            ModuleStreamProfileSummary model = new ModuleStreamProfileSummary(this.moduleName, this.streamName, this.profileName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStreamProfileSummary model) {
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("profileName")) {
                this.profileName(model.getProfileName());
            }
            return this;
        }
    }
}

