/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallModuleStreamProfileOnManagedInstanceConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(InstallModuleStreamProfileOnManagedInstanceConverter.class);

    public static InstallModuleStreamProfileOnManagedInstanceRequest interceptRequest(InstallModuleStreamProfileOnManagedInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, InstallModuleStreamProfileOnManagedInstanceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getModuleName(), (String)"moduleName is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstances").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceId())).path("actions").path("streamProfiles").path("install");
        target = target.queryParam("moduleName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getModuleName())});
        if (request.getStreamName() != null) {
            target = target.queryParam("streamName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStreamName())});
        }
        if (request.getProfileName() != null) {
            target = target.queryParam("profileName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getProfileName())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> fromResponse() {
        return InstallModuleStreamProfileOnManagedInstanceConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> transformer = new Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse>(){

            @Override
            public InstallModuleStreamProfileOnManagedInstanceResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                InstallModuleStreamProfileOnManagedInstanceResponse.Builder builder = InstallModuleStreamProfileOnManagedInstanceResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                Optional opcWorkRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-work-request-id");
                if (opcWorkRequestIdHeader.isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                InstallModuleStreamProfileOnManagedInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

