/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.ArchTypes;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrashEventSystemInformation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="architecture")
    private final ArchTypes architecture;
    @JsonProperty(value="kspliceEffectiveKernelVersion")
    private final String kspliceEffectiveKernelVersion;
    @JsonProperty(value="osFamily")
    private final OsFamilies osFamily;
    @JsonProperty(value="osName")
    private final String osName;
    @JsonProperty(value="osKernelRelease")
    private final String osKernelRelease;
    @JsonProperty(value="osKernelVersion")
    private final String osKernelVersion;
    @JsonProperty(value="osSystemVersion")
    private final String osSystemVersion;

    @Deprecated
    @ConstructorProperties(value={"architecture", "kspliceEffectiveKernelVersion", "osFamily", "osName", "osKernelRelease", "osKernelVersion", "osSystemVersion"})
    public CrashEventSystemInformation(ArchTypes architecture, String kspliceEffectiveKernelVersion, OsFamilies osFamily, String osName, String osKernelRelease, String osKernelVersion, String osSystemVersion) {
        this.architecture = architecture;
        this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
        this.osFamily = osFamily;
        this.osName = osName;
        this.osKernelRelease = osKernelRelease;
        this.osKernelVersion = osKernelVersion;
        this.osSystemVersion = osSystemVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ArchTypes getArchitecture() {
        return this.architecture;
    }

    public String getKspliceEffectiveKernelVersion() {
        return this.kspliceEffectiveKernelVersion;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsKernelRelease() {
        return this.osKernelRelease;
    }

    public String getOsKernelVersion() {
        return this.osKernelVersion;
    }

    public String getOsSystemVersion() {
        return this.osSystemVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CrashEventSystemInformation(");
        sb.append("super=").append(super.toString());
        sb.append("architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(", kspliceEffectiveKernelVersion=").append(String.valueOf(this.kspliceEffectiveKernelVersion));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", osName=").append(String.valueOf(this.osName));
        sb.append(", osKernelRelease=").append(String.valueOf(this.osKernelRelease));
        sb.append(", osKernelVersion=").append(String.valueOf(this.osKernelVersion));
        sb.append(", osSystemVersion=").append(String.valueOf(this.osSystemVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrashEventSystemInformation)) {
            return false;
        }
        CrashEventSystemInformation other = (CrashEventSystemInformation)((Object)o);
        return Objects.equals((Object)this.architecture, (Object)other.architecture) && Objects.equals(this.kspliceEffectiveKernelVersion, other.kspliceEffectiveKernelVersion) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.osName, other.osName) && Objects.equals(this.osKernelRelease, other.osKernelRelease) && Objects.equals(this.osKernelVersion, other.osKernelVersion) && Objects.equals(this.osSystemVersion, other.osSystemVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.kspliceEffectiveKernelVersion == null ? 43 : this.kspliceEffectiveKernelVersion.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.osName == null ? 43 : this.osName.hashCode());
        result = result * 59 + (this.osKernelRelease == null ? 43 : this.osKernelRelease.hashCode());
        result = result * 59 + (this.osKernelVersion == null ? 43 : this.osKernelVersion.hashCode());
        result = result * 59 + (this.osSystemVersion == null ? 43 : this.osSystemVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="architecture")
        private ArchTypes architecture;
        @JsonProperty(value="kspliceEffectiveKernelVersion")
        private String kspliceEffectiveKernelVersion;
        @JsonProperty(value="osFamily")
        private OsFamilies osFamily;
        @JsonProperty(value="osName")
        private String osName;
        @JsonProperty(value="osKernelRelease")
        private String osKernelRelease;
        @JsonProperty(value="osKernelVersion")
        private String osKernelVersion;
        @JsonProperty(value="osSystemVersion")
        private String osSystemVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder architecture(ArchTypes architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder kspliceEffectiveKernelVersion(String kspliceEffectiveKernelVersion) {
            this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
            this.__explicitlySet__.add("kspliceEffectiveKernelVersion");
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder osName(String osName) {
            this.osName = osName;
            this.__explicitlySet__.add("osName");
            return this;
        }

        public Builder osKernelRelease(String osKernelRelease) {
            this.osKernelRelease = osKernelRelease;
            this.__explicitlySet__.add("osKernelRelease");
            return this;
        }

        public Builder osKernelVersion(String osKernelVersion) {
            this.osKernelVersion = osKernelVersion;
            this.__explicitlySet__.add("osKernelVersion");
            return this;
        }

        public Builder osSystemVersion(String osSystemVersion) {
            this.osSystemVersion = osSystemVersion;
            this.__explicitlySet__.add("osSystemVersion");
            return this;
        }

        public CrashEventSystemInformation build() {
            CrashEventSystemInformation model = new CrashEventSystemInformation(this.architecture, this.kspliceEffectiveKernelVersion, this.osFamily, this.osName, this.osKernelRelease, this.osKernelVersion, this.osSystemVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CrashEventSystemInformation model) {
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("kspliceEffectiveKernelVersion")) {
                this.kspliceEffectiveKernelVersion(model.getKspliceEffectiveKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("osName")) {
                this.osName(model.getOsName());
            }
            if (model.wasPropertyExplicitlySet("osKernelRelease")) {
                this.osKernelRelease(model.getOsKernelRelease());
            }
            if (model.wasPropertyExplicitlySet("osKernelVersion")) {
                this.osKernelVersion(model.getOsKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("osSystemVersion")) {
                this.osSystemVersion(model.getOsSystemVersion());
            }
            return this;
        }
    }
}

