/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ManagedInstance;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetManagedInstanceConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(GetManagedInstanceConverter.class);

    public static GetManagedInstanceRequest interceptRequest(GetManagedInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetManagedInstanceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstances").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetManagedInstanceResponse> fromResponse() {
        return GetManagedInstanceConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetManagedInstanceResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetManagedInstanceResponse> transformer = new Function<Response, GetManagedInstanceResponse>(){

            @Override
            public GetManagedInstanceResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(ManagedInstance.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(ManagedInstance.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetManagedInstanceResponse.Builder builder = GetManagedInstanceResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.managedInstance((ManagedInstance)((Object)response.getItem()));
                Optional etagHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetManagedInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

