/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.ArchTypes;
import com.oracle.bmc.osmanagement.model.ChecksumTypes;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.LifecycleStates;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SoftwareSource {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="repoType")
    private final String repoType;
    @JsonProperty(value="archType")
    private final ArchTypes archType;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="parentId")
    private final String parentId;
    @JsonProperty(value="parentName")
    private final String parentName;
    @JsonProperty(value="checksumType")
    private final ChecksumTypes checksumType;
    @JsonProperty(value="maintainerName")
    private final String maintainerName;
    @JsonProperty(value="maintainerEmail")
    private final String maintainerEmail;
    @JsonProperty(value="maintainerPhone")
    private final String maintainerPhone;
    @JsonProperty(value="gpgKeyUrl")
    private final String gpgKeyUrl;
    @JsonProperty(value="gpgKeyId")
    private final String gpgKeyId;
    @JsonProperty(value="gpgKeyFingerprint")
    private final String gpgKeyFingerprint;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="lifecycleState")
    private final LifecycleStates lifecycleState;
    @JsonProperty(value="packages")
    private final Integer packages;
    @JsonProperty(value="associatedManagedInstances")
    private final List<Id> associatedManagedInstances;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "repoType", "archType", "url", "parentId", "parentName", "checksumType", "maintainerName", "maintainerEmail", "maintainerPhone", "gpgKeyUrl", "gpgKeyId", "gpgKeyFingerprint", "status", "lifecycleState", "packages", "associatedManagedInstances", "freeformTags", "definedTags"})
    public SoftwareSource(String id, String compartmentId, String displayName, String description, String repoType, ArchTypes archType, String url, String parentId, String parentName, ChecksumTypes checksumType, String maintainerName, String maintainerEmail, String maintainerPhone, String gpgKeyUrl, String gpgKeyId, String gpgKeyFingerprint, Status status, LifecycleStates lifecycleState, Integer packages, List<Id> associatedManagedInstances, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.repoType = repoType;
        this.archType = archType;
        this.url = url;
        this.parentId = parentId;
        this.parentName = parentName;
        this.checksumType = checksumType;
        this.maintainerName = maintainerName;
        this.maintainerEmail = maintainerEmail;
        this.maintainerPhone = maintainerPhone;
        this.gpgKeyUrl = gpgKeyUrl;
        this.gpgKeyId = gpgKeyId;
        this.gpgKeyFingerprint = gpgKeyFingerprint;
        this.status = status;
        this.lifecycleState = lifecycleState;
        this.packages = packages;
        this.associatedManagedInstances = associatedManagedInstances;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRepoType() {
        return this.repoType;
    }

    public ArchTypes getArchType() {
        return this.archType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public ChecksumTypes getChecksumType() {
        return this.checksumType;
    }

    public String getMaintainerName() {
        return this.maintainerName;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public String getMaintainerPhone() {
        return this.maintainerPhone;
    }

    public String getGpgKeyUrl() {
        return this.gpgKeyUrl;
    }

    public String getGpgKeyId() {
        return this.gpgKeyId;
    }

    public String getGpgKeyFingerprint() {
        return this.gpgKeyFingerprint;
    }

    public Status getStatus() {
        return this.status;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getPackages() {
        return this.packages;
    }

    public List<Id> getAssociatedManagedInstances() {
        return this.associatedManagedInstances;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwareSource(");
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", repoType=").append(String.valueOf(this.repoType));
        sb.append(", archType=").append(String.valueOf((Object)this.archType));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", parentId=").append(String.valueOf(this.parentId));
        sb.append(", parentName=").append(String.valueOf(this.parentName));
        sb.append(", checksumType=").append(String.valueOf((Object)this.checksumType));
        sb.append(", maintainerName=").append(String.valueOf(this.maintainerName));
        sb.append(", maintainerEmail=").append(String.valueOf(this.maintainerEmail));
        sb.append(", maintainerPhone=").append(String.valueOf(this.maintainerPhone));
        sb.append(", gpgKeyUrl=").append(String.valueOf(this.gpgKeyUrl));
        sb.append(", gpgKeyId=").append(String.valueOf(this.gpgKeyId));
        sb.append(", gpgKeyFingerprint=").append(String.valueOf(this.gpgKeyFingerprint));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(", associatedManagedInstances=").append(String.valueOf(this.associatedManagedInstances));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append("__explicitlySet__=").append(String.valueOf(this.__explicitlySet__));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareSource)) {
            return false;
        }
        SoftwareSource other = (SoftwareSource)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.repoType, other.repoType) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals(this.url, other.url) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.parentName, other.parentName) && Objects.equals((Object)this.checksumType, (Object)other.checksumType) && Objects.equals(this.maintainerName, other.maintainerName) && Objects.equals(this.maintainerEmail, other.maintainerEmail) && Objects.equals(this.maintainerPhone, other.maintainerPhone) && Objects.equals(this.gpgKeyUrl, other.gpgKeyUrl) && Objects.equals(this.gpgKeyId, other.gpgKeyId) && Objects.equals(this.gpgKeyFingerprint, other.gpgKeyFingerprint) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.packages, other.packages) && Objects.equals(this.associatedManagedInstances, other.associatedManagedInstances) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.__explicitlySet__, other.__explicitlySet__);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.repoType == null ? 43 : this.repoType.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.parentName == null ? 43 : this.parentName.hashCode());
        result = result * 59 + (this.checksumType == null ? 43 : this.checksumType.hashCode());
        result = result * 59 + (this.maintainerName == null ? 43 : this.maintainerName.hashCode());
        result = result * 59 + (this.maintainerEmail == null ? 43 : this.maintainerEmail.hashCode());
        result = result * 59 + (this.maintainerPhone == null ? 43 : this.maintainerPhone.hashCode());
        result = result * 59 + (this.gpgKeyUrl == null ? 43 : this.gpgKeyUrl.hashCode());
        result = result * 59 + (this.gpgKeyId == null ? 43 : this.gpgKeyId.hashCode());
        result = result * 59 + (this.gpgKeyFingerprint == null ? 43 : this.gpgKeyFingerprint.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        result = result * 59 + (this.associatedManagedInstances == null ? 43 : this.associatedManagedInstances.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.__explicitlySet__ == null ? 43 : this.__explicitlySet__.hashCode());
        return result;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public static enum Status {
        Normal("NORMAL"),
        Unreachable("UNREACHABLE"),
        Error("ERROR"),
        Warning("WARNING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="repoType")
        private String repoType;
        @JsonProperty(value="archType")
        private ArchTypes archType;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="parentName")
        private String parentName;
        @JsonProperty(value="checksumType")
        private ChecksumTypes checksumType;
        @JsonProperty(value="maintainerName")
        private String maintainerName;
        @JsonProperty(value="maintainerEmail")
        private String maintainerEmail;
        @JsonProperty(value="maintainerPhone")
        private String maintainerPhone;
        @JsonProperty(value="gpgKeyUrl")
        private String gpgKeyUrl;
        @JsonProperty(value="gpgKeyId")
        private String gpgKeyId;
        @JsonProperty(value="gpgKeyFingerprint")
        private String gpgKeyFingerprint;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="lifecycleState")
        private LifecycleStates lifecycleState;
        @JsonProperty(value="packages")
        private Integer packages;
        @JsonProperty(value="associatedManagedInstances")
        private List<Id> associatedManagedInstances;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder repoType(String repoType) {
            this.repoType = repoType;
            this.__explicitlySet__.add("repoType");
            return this;
        }

        public Builder archType(ArchTypes archType) {
            this.archType = archType;
            this.__explicitlySet__.add("archType");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.__explicitlySet__.add("parentId");
            return this;
        }

        public Builder parentName(String parentName) {
            this.parentName = parentName;
            this.__explicitlySet__.add("parentName");
            return this;
        }

        public Builder checksumType(ChecksumTypes checksumType) {
            this.checksumType = checksumType;
            this.__explicitlySet__.add("checksumType");
            return this;
        }

        public Builder maintainerName(String maintainerName) {
            this.maintainerName = maintainerName;
            this.__explicitlySet__.add("maintainerName");
            return this;
        }

        public Builder maintainerEmail(String maintainerEmail) {
            this.maintainerEmail = maintainerEmail;
            this.__explicitlySet__.add("maintainerEmail");
            return this;
        }

        public Builder maintainerPhone(String maintainerPhone) {
            this.maintainerPhone = maintainerPhone;
            this.__explicitlySet__.add("maintainerPhone");
            return this;
        }

        public Builder gpgKeyUrl(String gpgKeyUrl) {
            this.gpgKeyUrl = gpgKeyUrl;
            this.__explicitlySet__.add("gpgKeyUrl");
            return this;
        }

        public Builder gpgKeyId(String gpgKeyId) {
            this.gpgKeyId = gpgKeyId;
            this.__explicitlySet__.add("gpgKeyId");
            return this;
        }

        public Builder gpgKeyFingerprint(String gpgKeyFingerprint) {
            this.gpgKeyFingerprint = gpgKeyFingerprint;
            this.__explicitlySet__.add("gpgKeyFingerprint");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder packages(Integer packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public Builder associatedManagedInstances(List<Id> associatedManagedInstances) {
            this.associatedManagedInstances = associatedManagedInstances;
            this.__explicitlySet__.add("associatedManagedInstances");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public SoftwareSource build() {
            SoftwareSource __instance__ = new SoftwareSource(this.id, this.compartmentId, this.displayName, this.description, this.repoType, this.archType, this.url, this.parentId, this.parentName, this.checksumType, this.maintainerName, this.maintainerEmail, this.maintainerPhone, this.gpgKeyUrl, this.gpgKeyId, this.gpgKeyFingerprint, this.status, this.lifecycleState, this.packages, this.associatedManagedInstances, this.freeformTags, this.definedTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SoftwareSource o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).displayName(o.getDisplayName()).description(o.getDescription()).repoType(o.getRepoType()).archType(o.getArchType()).url(o.getUrl()).parentId(o.getParentId()).parentName(o.getParentName()).checksumType(o.getChecksumType()).maintainerName(o.getMaintainerName()).maintainerEmail(o.getMaintainerEmail()).maintainerPhone(o.getMaintainerPhone()).gpgKeyUrl(o.getGpgKeyUrl()).gpgKeyId(o.getGpgKeyId()).gpgKeyFingerprint(o.getGpgKeyFingerprint()).status(o.getStatus()).lifecycleState(o.getLifecycleState()).packages(o.getPackages()).associatedManagedInstances(o.getAssociatedManagedInstances()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

