/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.oracle.bmc.osmanagement.model.KernelCrashEvent;
import com.oracle.bmc.osmanagement.model.KernelOopsEvent;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="eventType", defaultImpl=Event.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=KernelOopsEvent.class, name="KERNEL_OOPS"), @JsonSubTypes.Type(value=KernelCrashEvent.class, name="KERNEL_CRASH")})
@JsonFilter(value="explicitlySetFilter")
public class Event {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="eventFingerprint")
    private final String eventFingerprint;
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "instanceId", "compartmentId", "tenancyId", "summary", "timestamp", "eventFingerprint", "count", "freeformTags", "definedTags", "systemTags"})
    protected Event(String id, String instanceId, String compartmentId, String tenancyId, String summary, Date timestamp, String eventFingerprint, Integer count, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.instanceId = instanceId;
        this.compartmentId = compartmentId;
        this.tenancyId = tenancyId;
        this.summary = summary;
        this.timestamp = timestamp;
        this.eventFingerprint = eventFingerprint;
        this.count = count;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getEventFingerprint() {
        return this.eventFingerprint;
    }

    public Integer getCount() {
        return this.count;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event(");
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", eventFingerprint=").append(String.valueOf(this.eventFingerprint));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.summary, other.summary) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.eventFingerprint, other.eventFingerprint) && Objects.equals(this.count, other.count) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.eventFingerprint == null ? 43 : this.eventFingerprint.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        return result;
    }
}

