/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.osmanagement.EventAsync;
import com.oracle.bmc.osmanagement.internal.http.DeleteEventContentConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventContentConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventReportConverter;
import com.oracle.bmc.osmanagement.internal.http.ListEventsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListRelatedEventsConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateEventConverter;
import com.oracle.bmc.osmanagement.internal.http.UploadEventContentConverter;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAsyncClient
implements EventAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EventAsyncClient.class);
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EventAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public EventAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<DeleteEventContentResponse> deleteEventContent(DeleteEventContentRequest request, AsyncHandler<DeleteEventContentRequest, DeleteEventContentResponse> handler) {
        LOG.trace("Called async deleteEventContent");
        DeleteEventContentRequest interceptedRequest = DeleteEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEventContentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "DeleteEventContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/DeleteEventContent");
        Function<Response, DeleteEventContentResponse> transformer = DeleteEventContentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteEventContentRequest, DeleteEventContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteEventContentRequest, DeleteEventContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEventResponse> getEvent(GetEventRequest request, AsyncHandler<GetEventRequest, GetEventResponse> handler) {
        LOG.trace("Called async getEvent");
        GetEventRequest interceptedRequest = GetEventConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEvent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/GetEvent");
        Function<Response, GetEventResponse> transformer = GetEventConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetEventRequest, GetEventResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEventRequest, GetEventResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEventContentResponse> getEventContent(GetEventContentRequest request, AsyncHandler<GetEventContentRequest, GetEventContentResponse> handler) {
        LOG.trace("Called async getEventContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getEventContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetEventContentRequest interceptedRequest = GetEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventContentConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEventContent", ib.getRequestUri().toString(), "");
        Function<Response, GetEventContentResponse> transformer = GetEventContentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetEventContentRequest, GetEventContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEventContentRequest, GetEventContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEventReportResponse> getEventReport(GetEventReportRequest request, AsyncHandler<GetEventReportRequest, GetEventReportResponse> handler) {
        LOG.trace("Called async getEventReport");
        GetEventReportRequest interceptedRequest = GetEventReportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventReportConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEventReport", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventReport/GetEventReport");
        Function<Response, GetEventReportResponse> transformer = GetEventReportConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetEventReportRequest, GetEventReportResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEventReportRequest, GetEventReportResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEventsResponse> listEvents(ListEventsRequest request, AsyncHandler<ListEventsRequest, ListEventsResponse> handler) {
        LOG.trace("Called async listEvents");
        ListEventsRequest interceptedRequest = ListEventsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEventsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "ListEvents", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventCollection/ListEvents");
        Function<Response, ListEventsResponse> transformer = ListEventsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListEventsRequest, ListEventsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEventsRequest, ListEventsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRelatedEventsResponse> listRelatedEvents(ListRelatedEventsRequest request, AsyncHandler<ListRelatedEventsRequest, ListRelatedEventsResponse> handler) {
        LOG.trace("Called async listRelatedEvents");
        ListRelatedEventsRequest interceptedRequest = ListRelatedEventsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRelatedEventsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "ListRelatedEvents", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/RelatedEventCollection/ListRelatedEvents");
        Function<Response, ListRelatedEventsResponse> transformer = ListRelatedEventsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListRelatedEventsRequest, ListRelatedEventsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRelatedEventsRequest, ListRelatedEventsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateEventResponse> updateEvent(UpdateEventRequest request, AsyncHandler<UpdateEventRequest, UpdateEventResponse> handler) {
        LOG.trace("Called async updateEvent");
        UpdateEventRequest interceptedRequest = UpdateEventConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEventConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "UpdateEvent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/UpdateEvent");
        Function<Response, UpdateEventResponse> transformer = UpdateEventConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateEventRequest, UpdateEventResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateEventDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateEventRequest, UpdateEventResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UploadEventContentResponse> uploadEventContent(UploadEventContentRequest request, AsyncHandler<UploadEventContentRequest, UploadEventContentResponse> handler) {
        LOG.trace("Called async uploadEventContent");
        UploadEventContentRequest interceptedRequest = UploadEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadEventContentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "UploadEventContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/UploadEventContent");
        Function<Response, UploadEventContentResponse> transformer = UploadEventContentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UploadEventContentRequest, UploadEventContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UploadEventContentRequest, UploadEventContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EventAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new EventAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

