/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.EventReport;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEventReportConverter {
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();
    private static final Logger LOG = LoggerFactory.getLogger(GetEventReportConverter.class);

    public static GetEventReportRequest interceptRequest(GetEventReportRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetEventReportRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstances").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceId())).path("events").path("report");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLatestTimestampLessThan() != null) {
            target = target.queryParam("latestTimestampLessThan", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLatestTimestampLessThan())});
        }
        if (request.getLatestTimestampGreaterThanOrEqualTo() != null) {
            target = target.queryParam("latestTimestampGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLatestTimestampGreaterThanOrEqualTo())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetEventReportResponse> fromResponse() {
        return GetEventReportConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetEventReportResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetEventReportResponse> transformer = new Function<Response, GetEventReportResponse>(){

            public GetEventReportResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetEventReportResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(EventReport.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(EventReport.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetEventReportResponse.Builder builder = GetEventReportResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.eventReport((EventReport)response.getItem());
                com.google.common.base.Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetEventReportResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

