/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osmanagement.OsManagement;
import com.oracle.bmc.osmanagement.OsManagementAsyncClient;
import com.oracle.bmc.osmanagement.OsManagementPaginators;
import com.oracle.bmc.osmanagement.OsManagementWaiters;
import com.oracle.bmc.osmanagement.internal.http.AddPackagesToSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachChildSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachManagedInstanceToManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachParentSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeManagedInstanceGroupCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeScheduledJobCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeSoftwareSourceCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachChildSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachManagedInstanceFromManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachParentSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DisableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.EnableModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetErratumConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamConverter;
import com.oracle.bmc.osmanagement.internal.http.GetModuleStreamProfileConverter;
import com.oracle.bmc.osmanagement.internal.http.GetScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwarePackageConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWindowsUpdateConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllPackageUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllUpdatesOnManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllWindowsUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallModuleStreamProfileOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallWindowsUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailablePackagesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableSoftwareSourcesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableWindowsUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceGroupsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstancesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamProfilesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListPackagesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListUpcomingScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.osmanagement.internal.http.ManageModuleStreamsOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemoveModuleStreamProfileFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackageFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackagesFromSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.RunScheduledJobNowConverter;
import com.oracle.bmc.osmanagement.internal.http.SearchSoftwarePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.SkipNextScheduledJobExecutionConverter;
import com.oracle.bmc.osmanagement.internal.http.SwitchModuleStreamOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DisableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.EnableModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallModuleStreamProfileOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamProfilesRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.ManageModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemoveModuleStreamProfileFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.SwitchModuleStreamOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DisableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.EnableModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallModuleStreamProfileOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamProfilesResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.ManageModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemoveModuleStreamProfileFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.SwitchModuleStreamOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementClient
implements OsManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementAsyncClient.class);
    private final OsManagementWaiters waiters;
    private final OsManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    RestClient getClient() {
        return this.client;
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        if (circuitBreakerConfiguration == null) {
            circuitBreakerConfiguration = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, null, circuitBreakerConfiguration);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("OsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OsManagementWaiters(executorService, this);
        this.paginators = new OsManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddPackagesToSoftwareSourceResponse addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request) {
        LOG.trace("Called addPackagesToSoftwareSource");
        AddPackagesToSoftwareSourceRequest interceptedRequest = AddPackagesToSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddPackagesToSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AddPackagesToSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/AddPackagesToSoftwareSource");
        Function<Response, AddPackagesToSoftwareSourceResponse> transformer = AddPackagesToSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (AddPackagesToSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddPackagesToSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (AddPackagesToSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachChildSoftwareSourceToManagedInstanceResponse attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachChildSoftwareSourceToManagedInstance");
        AttachChildSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachChildSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachChildSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachChildSoftwareSourceToManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachChildSoftwareSourceToManagedInstance");
        Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = AttachChildSoftwareSourceToManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachManagedInstanceToManagedInstanceGroupResponse attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request) {
        LOG.trace("Called attachManagedInstanceToManagedInstanceGroup");
        AttachManagedInstanceToManagedInstanceGroupRequest interceptedRequest = AttachManagedInstanceToManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachManagedInstanceToManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachManagedInstanceToManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/AttachManagedInstanceToManagedInstanceGroup");
        Function<Response, AttachManagedInstanceToManagedInstanceGroupResponse> transformer = AttachManagedInstanceToManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachParentSoftwareSourceToManagedInstanceResponse attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachParentSoftwareSourceToManagedInstance");
        AttachParentSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachParentSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachParentSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "AttachParentSoftwareSourceToManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/AttachParentSoftwareSourceToManagedInstance");
        Function<Response, AttachParentSoftwareSourceToManagedInstanceResponse> transformer = AttachParentSoftwareSourceToManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeManagedInstanceGroupCompartmentResponse changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request) {
        LOG.trace("Called changeManagedInstanceGroupCompartment");
        ChangeManagedInstanceGroupCompartmentRequest interceptedRequest = ChangeManagedInstanceGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedInstanceGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeManagedInstanceGroupCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/ChangeManagedInstanceGroupCompartment");
        Function<Response, ChangeManagedInstanceGroupCompartmentResponse> transformer = ChangeManagedInstanceGroupCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeManagedInstanceGroupCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeScheduledJobCompartmentResponse changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request) {
        LOG.trace("Called changeScheduledJobCompartment");
        ChangeScheduledJobCompartmentRequest interceptedRequest = ChangeScheduledJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeScheduledJobCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ChangeScheduledJobCompartment");
        Function<Response, ChangeScheduledJobCompartmentResponse> transformer = ChangeScheduledJobCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeScheduledJobCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeScheduledJobCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeScheduledJobCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeSoftwareSourceCompartmentResponse changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request) {
        LOG.trace("Called changeSoftwareSourceCompartment");
        ChangeSoftwareSourceCompartmentRequest interceptedRequest = ChangeSoftwareSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSoftwareSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ChangeSoftwareSourceCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ChangeSoftwareSourceCompartment");
        Function<Response, ChangeSoftwareSourceCompartmentResponse> transformer = ChangeSoftwareSourceCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeSoftwareSourceCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateManagedInstanceGroupResponse createManagedInstanceGroup(CreateManagedInstanceGroupRequest request) {
        LOG.trace("Called createManagedInstanceGroup");
        CreateManagedInstanceGroupRequest interceptedRequest = CreateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/CreateManagedInstanceGroup");
        Function<Response, CreateManagedInstanceGroupResponse> transformer = CreateManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateScheduledJobResponse createScheduledJob(CreateScheduledJobRequest request) {
        LOG.trace("Called createScheduledJob");
        CreateScheduledJobRequest interceptedRequest = CreateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/CreateScheduledJob");
        Function<Response, CreateScheduledJobResponse> transformer = CreateScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (CreateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateSoftwareSourceResponse createSoftwareSource(CreateSoftwareSourceRequest request) {
        LOG.trace("Called createSoftwareSource");
        CreateSoftwareSourceRequest interceptedRequest = CreateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "CreateSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/CreateSoftwareSource");
        Function<Response, CreateSoftwareSourceResponse> transformer = CreateSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (CreateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteManagedInstanceGroupResponse deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request) {
        LOG.trace("Called deleteManagedInstanceGroup");
        DeleteManagedInstanceGroupRequest interceptedRequest = DeleteManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DeleteManagedInstanceGroup");
        Function<Response, DeleteManagedInstanceGroupResponse> transformer = DeleteManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteScheduledJobResponse deleteScheduledJob(DeleteScheduledJobRequest request) {
        LOG.trace("Called deleteScheduledJob");
        DeleteScheduledJobRequest interceptedRequest = DeleteScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/DeleteScheduledJob");
        Function<Response, DeleteScheduledJobResponse> transformer = DeleteScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteSoftwareSourceResponse deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        LOG.trace("Called deleteSoftwareSource");
        DeleteSoftwareSourceRequest interceptedRequest = DeleteSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DeleteSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/DeleteSoftwareSource");
        Function<Response, DeleteSoftwareSourceResponse> transformer = DeleteSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachChildSoftwareSourceFromManagedInstanceResponse detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachChildSoftwareSourceFromManagedInstance");
        DetachChildSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachChildSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachChildSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachChildSoftwareSourceFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachChildSoftwareSourceFromManagedInstance");
        Function<Response, DetachChildSoftwareSourceFromManagedInstanceResponse> transformer = DetachChildSoftwareSourceFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachManagedInstanceFromManagedInstanceGroupResponse detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request) {
        LOG.trace("Called detachManagedInstanceFromManagedInstanceGroup");
        DetachManagedInstanceFromManagedInstanceGroupRequest interceptedRequest = DetachManagedInstanceFromManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachManagedInstanceFromManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachManagedInstanceFromManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/DetachManagedInstanceFromManagedInstanceGroup");
        Function<Response, DetachManagedInstanceFromManagedInstanceGroupResponse> transformer = DetachManagedInstanceFromManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachParentSoftwareSourceFromManagedInstanceResponse detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachParentSoftwareSourceFromManagedInstance");
        DetachParentSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachParentSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachParentSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DetachParentSoftwareSourceFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/DetachParentSoftwareSourceFromManagedInstance");
        Function<Response, DetachParentSoftwareSourceFromManagedInstanceResponse> transformer = DetachParentSoftwareSourceFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DisableModuleStreamOnManagedInstanceResponse disableModuleStreamOnManagedInstance(DisableModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called disableModuleStreamOnManagedInstance");
        DisableModuleStreamOnManagedInstanceRequest interceptedRequest = DisableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "DisableModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/DisableModuleStreamOnManagedInstance");
        Function<Response, DisableModuleStreamOnManagedInstanceResponse> transformer = DisableModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DisableModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DisableModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DisableModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public EnableModuleStreamOnManagedInstanceResponse enableModuleStreamOnManagedInstance(EnableModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called enableModuleStreamOnManagedInstance");
        EnableModuleStreamOnManagedInstanceRequest interceptedRequest = EnableModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "EnableModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/EnableModuleStreamOnManagedInstance");
        Function<Response, EnableModuleStreamOnManagedInstanceResponse> transformer = EnableModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (EnableModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EnableModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (EnableModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetErratumResponse getErratum(GetErratumRequest request) {
        LOG.trace("Called getErratum");
        GetErratumRequest interceptedRequest = GetErratumConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetErratumConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetErratum", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Erratum/GetErratum");
        Function<Response, GetErratumResponse> transformer = GetErratumConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetErratumResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetErratumResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetErratumResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceResponse getManagedInstance(GetManagedInstanceRequest request) {
        LOG.trace("Called getManagedInstance");
        GetManagedInstanceRequest interceptedRequest = GetManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/GetManagedInstance");
        Function<Response, GetManagedInstanceResponse> transformer = GetManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceGroupResponse getManagedInstanceGroup(GetManagedInstanceGroupRequest request) {
        LOG.trace("Called getManagedInstanceGroup");
        GetManagedInstanceGroupRequest interceptedRequest = GetManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/GetManagedInstanceGroup");
        Function<Response, GetManagedInstanceGroupResponse> transformer = GetManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModuleStreamResponse getModuleStream(GetModuleStreamRequest request) {
        LOG.trace("Called getModuleStream");
        GetModuleStreamRequest interceptedRequest = GetModuleStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetModuleStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStream/GetModuleStream");
        Function<Response, GetModuleStreamResponse> transformer = GetModuleStreamConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModuleStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModuleStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModuleStreamResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetModuleStreamProfileResponse getModuleStreamProfile(GetModuleStreamProfileRequest request) {
        LOG.trace("Called getModuleStreamProfile");
        GetModuleStreamProfileRequest interceptedRequest = GetModuleStreamProfileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModuleStreamProfileConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetModuleStreamProfile", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfile/GetModuleStreamProfile");
        Function<Response, GetModuleStreamProfileResponse> transformer = GetModuleStreamProfileConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModuleStreamProfileResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModuleStreamProfileResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModuleStreamProfileResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetScheduledJobResponse getScheduledJob(GetScheduledJobRequest request) {
        LOG.trace("Called getScheduledJob");
        GetScheduledJobRequest interceptedRequest = GetScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/GetScheduledJob");
        Function<Response, GetScheduledJobResponse> transformer = GetScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwarePackageResponse getSoftwarePackage(GetSoftwarePackageRequest request) {
        LOG.trace("Called getSoftwarePackage");
        GetSoftwarePackageRequest interceptedRequest = GetSoftwarePackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwarePackageConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetSoftwarePackage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwarePackage");
        Function<Response, GetSoftwarePackageResponse> transformer = GetSoftwarePackageConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetSoftwarePackageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwarePackageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwarePackageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwareSourceResponse getSoftwareSource(GetSoftwareSourceRequest request) {
        LOG.trace("Called getSoftwareSource");
        GetSoftwareSourceRequest interceptedRequest = GetSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/GetSoftwareSource");
        Function<Response, GetSoftwareSourceResponse> transformer = GetSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWindowsUpdateResponse getWindowsUpdate(GetWindowsUpdateRequest request) {
        LOG.trace("Called getWindowsUpdate");
        GetWindowsUpdateRequest interceptedRequest = GetWindowsUpdateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWindowsUpdateConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetWindowsUpdate", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdate/GetWindowsUpdate");
        Function<Response, GetWindowsUpdateResponse> transformer = GetWindowsUpdateConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetWindowsUpdateResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWindowsUpdateResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWindowsUpdateResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "GetWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/GetWorkRequest");
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllPackageUpdatesOnManagedInstanceResponse installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllPackageUpdatesOnManagedInstance");
        InstallAllPackageUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllPackageUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllPackageUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllPackageUpdatesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllPackageUpdatesOnManagedInstance");
        Function<Response, InstallAllPackageUpdatesOnManagedInstanceResponse> transformer = InstallAllPackageUpdatesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllUpdatesOnManagedInstanceGroupResponse installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request) {
        LOG.trace("Called installAllUpdatesOnManagedInstanceGroup");
        InstallAllUpdatesOnManagedInstanceGroupRequest interceptedRequest = InstallAllUpdatesOnManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllUpdatesOnManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllUpdatesOnManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/InstallAllUpdatesOnManagedInstanceGroup");
        Function<Response, InstallAllUpdatesOnManagedInstanceGroupResponse> transformer = InstallAllUpdatesOnManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllWindowsUpdatesOnManagedInstanceResponse installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllWindowsUpdatesOnManagedInstance");
        InstallAllWindowsUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllWindowsUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallAllWindowsUpdatesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallAllWindowsUpdatesOnManagedInstance");
        Function<Response, InstallAllWindowsUpdatesOnManagedInstanceResponse> transformer = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallModuleStreamProfileOnManagedInstanceResponse installModuleStreamProfileOnManagedInstance(InstallModuleStreamProfileOnManagedInstanceRequest request) {
        LOG.trace("Called installModuleStreamProfileOnManagedInstance");
        InstallModuleStreamProfileOnManagedInstanceRequest interceptedRequest = InstallModuleStreamProfileOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallModuleStreamProfileOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallModuleStreamProfileOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/InstallModuleStreamProfileOnManagedInstance");
        Function<Response, InstallModuleStreamProfileOnManagedInstanceResponse> transformer = InstallModuleStreamProfileOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallModuleStreamProfileOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageOnManagedInstanceResponse installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageOnManagedInstance");
        InstallPackageOnManagedInstanceRequest interceptedRequest = InstallPackageOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallPackageOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageOnManagedInstance");
        Function<Response, InstallPackageOnManagedInstanceResponse> transformer = InstallPackageOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallPackageOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageUpdateOnManagedInstanceResponse installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageUpdateOnManagedInstance");
        InstallPackageUpdateOnManagedInstanceRequest interceptedRequest = InstallPackageUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallPackageUpdateOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallPackageUpdateOnManagedInstance");
        Function<Response, InstallPackageUpdateOnManagedInstanceResponse> transformer = InstallPackageUpdateOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallPackageUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallWindowsUpdateOnManagedInstanceResponse installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installWindowsUpdateOnManagedInstance");
        InstallWindowsUpdateOnManagedInstanceRequest interceptedRequest = InstallWindowsUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallWindowsUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "InstallWindowsUpdateOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/InstallWindowsUpdateOnManagedInstance");
        Function<Response, InstallWindowsUpdateOnManagedInstanceResponse> transformer = InstallWindowsUpdateOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailablePackagesForManagedInstanceResponse listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailablePackagesForManagedInstance");
        ListAvailablePackagesForManagedInstanceRequest interceptedRequest = ListAvailablePackagesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailablePackagesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailablePackagesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailablePackagesForManagedInstance");
        Function<Response, ListAvailablePackagesForManagedInstanceResponse> transformer = ListAvailablePackagesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListAvailablePackagesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableSoftwareSourcesForManagedInstanceResponse listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableSoftwareSourcesForManagedInstance");
        ListAvailableSoftwareSourcesForManagedInstanceRequest interceptedRequest = ListAvailableSoftwareSourcesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableSoftwareSourcesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableSoftwareSourcesForManagedInstance");
        Function<Response, ListAvailableSoftwareSourcesForManagedInstanceResponse> transformer = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableUpdatesForManagedInstanceResponse listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableUpdatesForManagedInstance");
        ListAvailableUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableUpdatesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableUpdatesForManagedInstance");
        Function<Response, ListAvailableUpdatesForManagedInstanceResponse> transformer = ListAvailableUpdatesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListAvailableUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableWindowsUpdatesForManagedInstanceResponse listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableWindowsUpdatesForManagedInstance");
        ListAvailableWindowsUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableWindowsUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListAvailableWindowsUpdatesForManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListAvailableWindowsUpdatesForManagedInstance");
        Function<Response, ListAvailableWindowsUpdatesForManagedInstanceResponse> transformer = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListErrataResponse listErrata(ListErrataRequest request) {
        LOG.trace("Called listErrata");
        ListErrataRequest interceptedRequest = ListErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListErrataConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListErrata", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ErratumSummary/ListErrata");
        Function<Response, ListErrataResponse> transformer = ListErrataConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceErrataResponse listManagedInstanceErrata(ListManagedInstanceErrataRequest request) {
        LOG.trace("Called listManagedInstanceErrata");
        ListManagedInstanceErrataRequest interceptedRequest = ListManagedInstanceErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceErrataConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstanceErrata", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListManagedInstanceErrata");
        Function<Response, ListManagedInstanceErrataResponse> transformer = ListManagedInstanceErrataConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListManagedInstanceErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceGroupsResponse listManagedInstanceGroups(ListManagedInstanceGroupsRequest request) {
        LOG.trace("Called listManagedInstanceGroups");
        ListManagedInstanceGroupsRequest interceptedRequest = ListManagedInstanceGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceGroupsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstanceGroups", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroupSummary/ListManagedInstanceGroups");
        Function<Response, ListManagedInstanceGroupsResponse> transformer = ListManagedInstanceGroupsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListManagedInstanceGroupsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceGroupsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceGroupsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstancesResponse listManagedInstances(ListManagedInstancesRequest request) {
        LOG.trace("Called listManagedInstances");
        ListManagedInstancesRequest interceptedRequest = ListManagedInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstancesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListManagedInstances", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceSummary/ListManagedInstances");
        Function<Response, ListManagedInstancesResponse> transformer = ListManagedInstancesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListManagedInstancesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstancesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstancesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamProfilesResponse listModuleStreamProfiles(ListModuleStreamProfilesRequest request) {
        LOG.trace("Called listModuleStreamProfiles");
        ListModuleStreamProfilesRequest interceptedRequest = ListModuleStreamProfilesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamProfiles", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileSummary/ListModuleStreamProfiles");
        Function<Response, ListModuleStreamProfilesResponse> transformer = ListModuleStreamProfilesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModuleStreamProfilesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamProfilesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamProfilesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamProfilesOnManagedInstanceResponse listModuleStreamProfilesOnManagedInstance(ListModuleStreamProfilesOnManagedInstanceRequest request) {
        LOG.trace("Called listModuleStreamProfilesOnManagedInstance");
        ListModuleStreamProfilesOnManagedInstanceRequest interceptedRequest = ListModuleStreamProfilesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamProfilesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamProfilesOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamProfilesOnManagedInstance");
        Function<Response, ListModuleStreamProfilesOnManagedInstanceResponse> transformer = ListModuleStreamProfilesOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamProfilesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamsResponse listModuleStreams(ListModuleStreamsRequest request) {
        LOG.trace("Called listModuleStreams");
        ListModuleStreamsRequest interceptedRequest = ListModuleStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreams", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamSummary/ListModuleStreams");
        Function<Response, ListModuleStreamsResponse> transformer = ListModuleStreamsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModuleStreamsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListModuleStreamsOnManagedInstanceResponse listModuleStreamsOnManagedInstance(ListModuleStreamsOnManagedInstanceRequest request) {
        LOG.trace("Called listModuleStreamsOnManagedInstance");
        ListModuleStreamsOnManagedInstanceRequest interceptedRequest = ListModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListModuleStreamsOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListModuleStreamsOnManagedInstance");
        Function<Response, ListModuleStreamsOnManagedInstanceResponse> transformer = ListModuleStreamsOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModuleStreamsOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModuleStreamsOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModuleStreamsOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListPackagesInstalledOnManagedInstanceResponse listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listPackagesInstalledOnManagedInstance");
        ListPackagesInstalledOnManagedInstanceRequest interceptedRequest = ListPackagesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListPackagesInstalledOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListPackagesInstalledOnManagedInstance");
        Function<Response, ListPackagesInstalledOnManagedInstanceResponse> transformer = ListPackagesInstalledOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListPackagesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListScheduledJobsResponse listScheduledJobs(ListScheduledJobsRequest request) {
        LOG.trace("Called listScheduledJobs");
        ListScheduledJobsRequest interceptedRequest = ListScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListScheduledJobs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListScheduledJobs");
        Function<Response, ListScheduledJobsResponse> transformer = ListScheduledJobsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcePackagesResponse listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request) {
        LOG.trace("Called listSoftwareSourcePackages");
        ListSoftwareSourcePackagesRequest interceptedRequest = ListSoftwareSourcePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcePackagesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListSoftwareSourcePackages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/ListSoftwareSourcePackages");
        Function<Response, ListSoftwareSourcePackagesResponse> transformer = ListSoftwareSourcePackagesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListSoftwareSourcePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcesResponse listSoftwareSources(ListSoftwareSourcesRequest request) {
        LOG.trace("Called listSoftwareSources");
        ListSoftwareSourcesRequest interceptedRequest = ListSoftwareSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListSoftwareSources", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSourceSummary/ListSoftwareSources");
        Function<Response, ListSoftwareSourcesResponse> transformer = ListSoftwareSourcesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListSoftwareSourcesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListUpcomingScheduledJobsResponse listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request) {
        LOG.trace("Called listUpcomingScheduledJobs");
        ListUpcomingScheduledJobsRequest interceptedRequest = ListUpcomingScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUpcomingScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListUpcomingScheduledJobs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/ListUpcomingScheduledJobs");
        Function<Response, ListUpcomingScheduledJobsResponse> transformer = ListUpcomingScheduledJobsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListUpcomingScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUpcomingScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUpcomingScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesResponse listWindowsUpdates(ListWindowsUpdatesRequest request) {
        LOG.trace("Called listWindowsUpdates");
        ListWindowsUpdatesRequest interceptedRequest = ListWindowsUpdatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWindowsUpdates", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WindowsUpdateSummary/ListWindowsUpdates");
        Function<Response, ListWindowsUpdatesResponse> transformer = ListWindowsUpdatesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWindowsUpdatesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesInstalledOnManagedInstanceResponse listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listWindowsUpdatesInstalledOnManagedInstance");
        ListWindowsUpdatesInstalledOnManagedInstanceRequest interceptedRequest = ListWindowsUpdatesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWindowsUpdatesInstalledOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ListWindowsUpdatesInstalledOnManagedInstance");
        Function<Response, ListWindowsUpdatesInstalledOnManagedInstanceResponse> transformer = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequestErrors", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestErrors");
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequestLogs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequest/ListWorkRequestLogs");
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ListWorkRequests", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/WorkRequestSummary/ListWorkRequests");
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ManageModuleStreamsOnManagedInstanceResponse manageModuleStreamsOnManagedInstance(ManageModuleStreamsOnManagedInstanceRequest request) {
        LOG.trace("Called manageModuleStreamsOnManagedInstance");
        ManageModuleStreamsOnManagedInstanceRequest interceptedRequest = ManageModuleStreamsOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ManageModuleStreamsOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "ManageModuleStreamsOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/ManageModuleStreamsOnManagedInstance");
        Function<Response, ManageModuleStreamsOnManagedInstanceResponse> transformer = ManageModuleStreamsOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ManageModuleStreamsOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ManageModuleStreamsOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getManageModuleStreamsOnManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (ManageModuleStreamsOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemoveModuleStreamProfileFromManagedInstanceResponse removeModuleStreamProfileFromManagedInstance(RemoveModuleStreamProfileFromManagedInstanceRequest request) {
        LOG.trace("Called removeModuleStreamProfileFromManagedInstance");
        RemoveModuleStreamProfileFromManagedInstanceRequest interceptedRequest = RemoveModuleStreamProfileFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveModuleStreamProfileFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemoveModuleStreamProfileFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamProfileDetails/RemoveModuleStreamProfileFromManagedInstance");
        Function<Response, RemoveModuleStreamProfileFromManagedInstanceResponse> transformer = RemoveModuleStreamProfileFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RemoveModuleStreamProfileFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackageFromManagedInstanceResponse removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request) {
        LOG.trace("Called removePackageFromManagedInstance");
        RemovePackageFromManagedInstanceRequest interceptedRequest = RemovePackageFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackageFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemovePackageFromManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstance/RemovePackageFromManagedInstance");
        Function<Response, RemovePackageFromManagedInstanceResponse> transformer = RemovePackageFromManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (RemovePackageFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackageFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RemovePackageFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackagesFromSoftwareSourceResponse removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request) {
        LOG.trace("Called removePackagesFromSoftwareSource");
        RemovePackagesFromSoftwareSourceRequest interceptedRequest = RemovePackagesFromSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackagesFromSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RemovePackagesFromSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/RemovePackagesFromSoftwareSource");
        Function<Response, RemovePackagesFromSoftwareSourceResponse> transformer = RemovePackagesFromSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (RemovePackagesFromSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RunScheduledJobNowResponse runScheduledJobNow(RunScheduledJobNowRequest request) {
        LOG.trace("Called runScheduledJobNow");
        RunScheduledJobNowRequest interceptedRequest = RunScheduledJobNowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunScheduledJobNowConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "RunScheduledJobNow", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/RunScheduledJobNow");
        Function<Response, RunScheduledJobNowResponse> transformer = RunScheduledJobNowConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (RunScheduledJobNowResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RunScheduledJobNowResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RunScheduledJobNowResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SearchSoftwarePackagesResponse searchSoftwarePackages(SearchSoftwarePackagesRequest request) {
        LOG.trace("Called searchSoftwarePackages");
        SearchSoftwarePackagesRequest interceptedRequest = SearchSoftwarePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchSoftwarePackagesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SearchSoftwarePackages", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/SearchSoftwarePackages");
        Function<Response, SearchSoftwarePackagesResponse> transformer = SearchSoftwarePackagesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (SearchSoftwarePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SearchSoftwarePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SearchSoftwarePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SkipNextScheduledJobExecutionResponse skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request) {
        LOG.trace("Called skipNextScheduledJobExecution");
        SkipNextScheduledJobExecutionRequest interceptedRequest = SkipNextScheduledJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipNextScheduledJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SkipNextScheduledJobExecution", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/SkipNextScheduledJobExecution");
        Function<Response, SkipNextScheduledJobExecutionResponse> transformer = SkipNextScheduledJobExecutionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (SkipNextScheduledJobExecutionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SkipNextScheduledJobExecutionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SkipNextScheduledJobExecutionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SwitchModuleStreamOnManagedInstanceResponse switchModuleStreamOnManagedInstance(SwitchModuleStreamOnManagedInstanceRequest request) {
        LOG.trace("Called switchModuleStreamOnManagedInstance");
        SwitchModuleStreamOnManagedInstanceRequest interceptedRequest = SwitchModuleStreamOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SwitchModuleStreamOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "SwitchModuleStreamOnManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ModuleStreamDetails/SwitchModuleStreamOnManagedInstance");
        Function<Response, SwitchModuleStreamOnManagedInstanceResponse> transformer = SwitchModuleStreamOnManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (SwitchModuleStreamOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SwitchModuleStreamOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SwitchModuleStreamOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceResponse updateManagedInstance(UpdateManagedInstanceRequest request) {
        LOG.trace("Called updateManagedInstance");
        UpdateManagedInstanceRequest interceptedRequest = UpdateManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateManagedInstance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/UpdateManagedInstanceDetails/UpdateManagedInstance");
        Function<Response, UpdateManagedInstanceResponse> transformer = UpdateManagedInstanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceGroupResponse updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request) {
        LOG.trace("Called updateManagedInstanceGroup");
        UpdateManagedInstanceGroupRequest interceptedRequest = UpdateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateManagedInstanceGroup", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ManagedInstanceGroup/UpdateManagedInstanceGroup");
        Function<Response, UpdateManagedInstanceGroupResponse> transformer = UpdateManagedInstanceGroupConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateScheduledJobResponse updateScheduledJob(UpdateScheduledJobRequest request) {
        LOG.trace("Called updateScheduledJob");
        UpdateScheduledJobRequest interceptedRequest = UpdateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateScheduledJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/ScheduledJob/UpdateScheduledJob");
        Function<Response, UpdateScheduledJobResponse> transformer = UpdateScheduledJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateSoftwareSourceResponse updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        LOG.trace("Called updateSoftwareSource");
        UpdateSoftwareSourceRequest interceptedRequest = UpdateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("OsManagement", "UpdateSoftwareSource", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/SoftwareSource/UpdateSoftwareSource");
        Function<Response, UpdateSoftwareSourceResponse> transformer = UpdateSoftwareSourceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (UpdateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public OsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OsManagementPaginators getPaginators() {
        return this.paginators;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OsManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OsManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

