/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.IsEligibleForInstallation;
import com.oracle.bmc.osmanagement.model.UpdateTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WindowsUpdateSummary {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="updateType")
    private final UpdateTypes updateType;
    @JsonProperty(value="installable")
    private final IsEligibleForInstallation installable;
    @JsonProperty(value="isRebootRequiredForInstallation")
    private final Boolean isRebootRequiredForInstallation;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "updateType", "installable", "isRebootRequiredForInstallation"})
    public WindowsUpdateSummary(String displayName, String name, UpdateTypes updateType, IsEligibleForInstallation installable, Boolean isRebootRequiredForInstallation) {
        this.displayName = displayName;
        this.name = name;
        this.updateType = updateType;
        this.installable = installable;
        this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public UpdateTypes getUpdateType() {
        return this.updateType;
    }

    public IsEligibleForInstallation getInstallable() {
        return this.installable;
    }

    public Boolean getIsRebootRequiredForInstallation() {
        return this.isRebootRequiredForInstallation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WindowsUpdateSummary(");
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", installable=").append(String.valueOf((Object)this.installable));
        sb.append(", isRebootRequiredForInstallation=").append(String.valueOf(this.isRebootRequiredForInstallation));
        sb.append("__explicitlySet__=").append(String.valueOf(this.__explicitlySet__));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowsUpdateSummary)) {
            return false;
        }
        WindowsUpdateSummary other = (WindowsUpdateSummary)o;
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals((Object)this.installable, (Object)other.installable) && Objects.equals(this.isRebootRequiredForInstallation, other.isRebootRequiredForInstallation) && Objects.equals(this.__explicitlySet__, other.__explicitlySet__);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.installable == null ? 43 : this.installable.hashCode());
        result = result * 59 + (this.isRebootRequiredForInstallation == null ? 43 : this.isRebootRequiredForInstallation.hashCode());
        result = result * 59 + (this.__explicitlySet__ == null ? 43 : this.__explicitlySet__.hashCode());
        return result;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="updateType")
        private UpdateTypes updateType;
        @JsonProperty(value="installable")
        private IsEligibleForInstallation installable;
        @JsonProperty(value="isRebootRequiredForInstallation")
        private Boolean isRebootRequiredForInstallation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder updateType(UpdateTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder installable(IsEligibleForInstallation installable) {
            this.installable = installable;
            this.__explicitlySet__.add("installable");
            return this;
        }

        public Builder isRebootRequiredForInstallation(Boolean isRebootRequiredForInstallation) {
            this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
            this.__explicitlySet__.add("isRebootRequiredForInstallation");
            return this;
        }

        public WindowsUpdateSummary build() {
            WindowsUpdateSummary __instance__ = new WindowsUpdateSummary(this.displayName, this.name, this.updateType, this.installable, this.isRebootRequiredForInstallation);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WindowsUpdateSummary o) {
            Builder copiedBuilder = this.displayName(o.getDisplayName()).name(o.getName()).updateType(o.getUpdateType()).installable(o.getInstallable()).isRebootRequiredForInstallation(o.getIsRebootRequiredForInstallation());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

