/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class DisableModuleStreamOnManagedInstanceRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String moduleName;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;
    private String streamName;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).moduleName(this.moduleName).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).streamName(this.streamName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",moduleName=").append(String.valueOf(this.moduleName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",streamName=").append(String.valueOf(this.streamName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisableModuleStreamOnManagedInstanceRequest)) {
            return false;
        }
        DisableModuleStreamOnManagedInstanceRequest other = (DisableModuleStreamOnManagedInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.streamName, other.streamName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DisableModuleStreamOnManagedInstanceRequest, Void> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private String moduleName = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String streamName = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DisableModuleStreamOnManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.moduleName(o.getModuleName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.streamName(o.getStreamName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DisableModuleStreamOnManagedInstanceRequest build() {
            DisableModuleStreamOnManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DisableModuleStreamOnManagedInstanceRequest buildWithoutInvocationCallback() {
            DisableModuleStreamOnManagedInstanceRequest request = new DisableModuleStreamOnManagedInstanceRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.moduleName = this.moduleName;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.streamName = this.streamName;
            return request;
        }
    }
}

