/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource {
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="actionType")
    private final ActionType actionType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="entityUri")
    private final String entityUri;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    @Deprecated
    @ConstructorProperties(value={"entityType", "actionType", "identifier", "name", "entityUri"})
    public WorkRequestResource(String entityType, ActionType actionType, String identifier, String name, String entityUri) {
        this.entityType = entityType;
        this.actionType = actionType;
        this.identifier = identifier;
        this.name = name;
        this.entityUri = entityUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getEntityUri() {
        return this.entityUri;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("entityType=").append(String.valueOf(this.entityType));
        sb.append(", actionType=").append(String.valueOf((Object)this.actionType));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", entityUri=").append(String.valueOf(this.entityUri));
        sb.append("__explicitlySet__=").append(String.valueOf(this.__explicitlySet__));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)o;
        return Objects.equals(this.entityType, other.entityType) && Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.entityUri, other.entityUri) && Objects.equals(this.__explicitlySet__, other.__explicitlySet__);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.actionType == null ? 43 : this.actionType.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.entityUri == null ? 43 : this.entityUri.hashCode());
        result = result * 59 + (this.__explicitlySet__ == null ? 43 : this.__explicitlySet__.hashCode());
        return result;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public static enum ActionType {
        Created("CREATED"),
        Updated("UPDATED"),
        Deleted("DELETED"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        Installed("INSTALLED"),
        Removed("REMOVED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="actionType")
        private ActionType actionType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="entityUri")
        private String entityUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder actionType(ActionType actionType) {
            this.actionType = actionType;
            this.__explicitlySet__.add("actionType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder entityUri(String entityUri) {
            this.entityUri = entityUri;
            this.__explicitlySet__.add("entityUri");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource __instance__ = new WorkRequestResource(this.entityType, this.actionType, this.identifier, this.name, this.entityUri);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource o) {
            Builder copiedBuilder = this.entityType(o.getEntityType()).actionType(o.getActionType()).identifier(o.getIdentifier()).name(o.getName()).entityUri(o.getEntityUri());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

