/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.osmanagement.OsManagement;
import com.oracle.bmc.osmanagement.model.LifecycleStates;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class OsManagementWaiters {
    private final ExecutorService executorService;
    private final OsManagement client;

    public OsManagementWaiters(ExecutorService executorService, OsManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(GetManagedInstanceGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedInstanceGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> forManagedInstanceGroup(BmcGenericWaiter waiter, GetManagedInstanceGroupRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse>(){

            public GetManagedInstanceGroupResponse apply(GetManagedInstanceGroupRequest request) {
                return OsManagementWaiters.this.client.getManagedInstanceGroup(request);
            }
        }, (Predicate)new Predicate<GetManagedInstanceGroupResponse>(){

            public boolean apply(GetManagedInstanceGroupResponse response) {
                return targetStatesSet.contains((Object)response.getManagedInstanceGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(GetScheduledJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduledJobRequest, GetScheduledJobResponse> forScheduledJob(BmcGenericWaiter waiter, GetScheduledJobRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetScheduledJobRequest, GetScheduledJobResponse>(){

            public GetScheduledJobResponse apply(GetScheduledJobRequest request) {
                return OsManagementWaiters.this.client.getScheduledJob(request);
            }
        }, (Predicate)new Predicate<GetScheduledJobResponse>(){

            public boolean apply(GetScheduledJobResponse response) {
                return targetStatesSet.contains((Object)response.getScheduledJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(GetSoftwareSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSoftwareSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSoftwareSourceRequest, GetSoftwareSourceResponse> forSoftwareSource(BmcGenericWaiter waiter, GetSoftwareSourceRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetSoftwareSourceRequest, GetSoftwareSourceResponse>(){

            public GetSoftwareSourceResponse apply(GetSoftwareSourceRequest request) {
                return OsManagementWaiters.this.client.getSoftwareSource(request);
            }
        }, (Predicate)new Predicate<GetSoftwareSourceResponse>(){

            public boolean apply(GetSoftwareSourceResponse response) {
                return targetStatesSet.contains((Object)response.getSoftwareSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OsManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

