/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ModuleStreamOnManagedInstanceSummary;
import com.oracle.bmc.osmanagement.requests.ListModuleStreamsOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListModuleStreamsOnManagedInstanceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListModuleStreamsOnManagedInstanceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListModuleStreamsOnManagedInstanceRequest interceptRequest(ListModuleStreamsOnManagedInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListModuleStreamsOnManagedInstanceRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstances").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceId())).path("moduleStreams");
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        if (request.getModuleName() != null) {
            target = target.queryParam("moduleName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getModuleName())});
        }
        if (request.getStreamName() != null) {
            target = target.queryParam("streamName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStreamName())});
        }
        if (request.getStreamStatus() != null) {
            target = target.queryParam("streamStatus", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStreamStatus().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListModuleStreamsOnManagedInstanceResponse> fromResponse() {
        Function<Response, ListModuleStreamsOnManagedInstanceResponse> transformer = new Function<Response, ListModuleStreamsOnManagedInstanceResponse>(){

            public ListModuleStreamsOnManagedInstanceResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.ListModuleStreamsOnManagedInstanceResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<ModuleStreamOnManagedInstanceSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListModuleStreamsOnManagedInstanceResponse.Builder builder = ListModuleStreamsOnManagedInstanceResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id");
                if (opcWorkRequestIdHeader.isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListModuleStreamsOnManagedInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

