/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetModuleStreamRequest
extends BmcRequest<Void> {
    private String softwareSourceId;
    private String moduleName;
    private String streamName;
    private String opcRequestId;

    @ConstructorProperties(value={"softwareSourceId", "moduleName", "streamName", "opcRequestId"})
    GetModuleStreamRequest(String softwareSourceId, String moduleName, String streamName, String opcRequestId) {
        this.softwareSourceId = softwareSourceId;
        this.moduleName = moduleName;
        this.streamName = streamName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().softwareSourceId(this.softwareSourceId).moduleName(this.moduleName).streamName(this.streamName).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetModuleStreamRequest(super=" + super.toString() + ", softwareSourceId=" + this.getSoftwareSourceId() + ", moduleName=" + this.getModuleName() + ", streamName=" + this.getStreamName() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetModuleStreamRequest)) {
            return false;
        }
        GetModuleStreamRequest other = (GetModuleStreamRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$softwareSourceId = this.getSoftwareSourceId();
        String other$softwareSourceId = other.getSoftwareSourceId();
        if (this$softwareSourceId == null ? other$softwareSourceId != null : !this$softwareSourceId.equals(other$softwareSourceId)) {
            return false;
        }
        String this$moduleName = this.getModuleName();
        String other$moduleName = other.getModuleName();
        if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetModuleStreamRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $softwareSourceId = this.getSoftwareSourceId();
        result = result * 59 + ($softwareSourceId == null ? 43 : $softwareSourceId.hashCode());
        String $moduleName = this.getModuleName();
        result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetModuleStreamRequest, Void> {
        private String softwareSourceId;
        private String moduleName;
        private String streamName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetModuleStreamRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.moduleName(o.getModuleName());
            this.streamName(o.getStreamName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetModuleStreamRequest build() {
            GetModuleStreamRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetModuleStreamRequest buildWithoutInvocationCallback() {
            return new GetModuleStreamRequest(this.softwareSourceId, this.moduleName, this.streamName, this.opcRequestId);
        }

        public String toString() {
            return "GetModuleStreamRequest.Builder(softwareSourceId=" + this.softwareSourceId + ", moduleName=" + this.moduleName + ", streamName=" + this.streamName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

