/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.osmanagement.model.LifecycleStates;
import com.oracle.bmc.osmanagement.model.OperationTypes;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListScheduledJobsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private String managedInstanceId;
    private String managedInstanceGroupId;
    private OperationTypes operationType;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private LifecycleStates lifecycleState;
    private String opcRequestId;
    private OsFamilies osFamily;

    @ConstructorProperties(value={"compartmentId", "displayName", "managedInstanceId", "managedInstanceGroupId", "operationType", "limit", "page", "sortOrder", "sortBy", "lifecycleState", "opcRequestId", "osFamily"})
    ListScheduledJobsRequest(String compartmentId, String displayName, String managedInstanceId, String managedInstanceGroupId, OperationTypes operationType, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, LifecycleStates lifecycleState, String opcRequestId, OsFamilies osFamily) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.managedInstanceId = managedInstanceId;
        this.managedInstanceGroupId = managedInstanceGroupId;
        this.operationType = operationType;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
        this.osFamily = osFamily;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).managedInstanceId(this.managedInstanceId).managedInstanceGroupId(this.managedInstanceGroupId).operationType(this.operationType).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId).osFamily(this.osFamily);
    }

    public String toString() {
        return "ListScheduledJobsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", displayName=" + this.getDisplayName() + ", managedInstanceId=" + this.getManagedInstanceId() + ", managedInstanceGroupId=" + this.getManagedInstanceGroupId() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", opcRequestId=" + this.getOpcRequestId() + ", osFamily=" + (Object)((Object)this.getOsFamily()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListScheduledJobsRequest)) {
            return false;
        }
        ListScheduledJobsRequest other = (ListScheduledJobsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$managedInstanceId = this.getManagedInstanceId();
        String other$managedInstanceId = other.getManagedInstanceId();
        if (this$managedInstanceId == null ? other$managedInstanceId != null : !this$managedInstanceId.equals(other$managedInstanceId)) {
            return false;
        }
        String this$managedInstanceGroupId = this.getManagedInstanceGroupId();
        String other$managedInstanceGroupId = other.getManagedInstanceGroupId();
        if (this$managedInstanceGroupId == null ? other$managedInstanceGroupId != null : !this$managedInstanceGroupId.equals(other$managedInstanceGroupId)) {
            return false;
        }
        OperationTypes this$operationType = this.getOperationType();
        OperationTypes other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        LifecycleStates this$lifecycleState = this.getLifecycleState();
        LifecycleStates other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        OsFamilies this$osFamily = this.getOsFamily();
        OsFamilies other$osFamily = other.getOsFamily();
        return !(this$osFamily == null ? other$osFamily != null : !((Object)((Object)this$osFamily)).equals((Object)other$osFamily));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListScheduledJobsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $managedInstanceId = this.getManagedInstanceId();
        result = result * 59 + ($managedInstanceId == null ? 43 : $managedInstanceId.hashCode());
        String $managedInstanceGroupId = this.getManagedInstanceGroupId();
        result = result * 59 + ($managedInstanceGroupId == null ? 43 : $managedInstanceGroupId.hashCode());
        OperationTypes $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        LifecycleStates $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        OsFamilies $osFamily = this.getOsFamily();
        result = result * 59 + ($osFamily == null ? 43 : ((Object)((Object)$osFamily)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public OperationTypes getOperationType() {
        return this.operationType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScheduledJobsRequest, Void> {
        private String compartmentId;
        private String displayName;
        private String managedInstanceId;
        private String managedInstanceGroupId;
        private OperationTypes operationType;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private LifecycleStates lifecycleState;
        private String opcRequestId;
        private OsFamilies osFamily;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScheduledJobsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.managedInstanceId(o.getManagedInstanceId());
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.operationType(o.getOperationType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.osFamily(o.getOsFamily());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScheduledJobsRequest build() {
            ListScheduledJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder operationType(OperationTypes operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public ListScheduledJobsRequest buildWithoutInvocationCallback() {
            return new ListScheduledJobsRequest(this.compartmentId, this.displayName, this.managedInstanceId, this.managedInstanceGroupId, this.operationType, this.limit, this.page, this.sortOrder, this.sortBy, this.lifecycleState, this.opcRequestId, this.osFamily);
        }

        public String toString() {
            return "ListScheduledJobsRequest.Builder(compartmentId=" + this.compartmentId + ", displayName=" + this.displayName + ", managedInstanceId=" + this.managedInstanceId + ", managedInstanceGroupId=" + this.managedInstanceGroupId + ", operationType=" + (Object)((Object)this.operationType) + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", opcRequestId=" + this.opcRequestId + ", osFamily=" + (Object)((Object)this.osFamily) + ")";
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

