/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListErrataRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String erratumId;
    private String advisoryName;
    private Date timeIssueDateStart;
    private Date timeIssueDateEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "erratumId", "advisoryName", "timeIssueDateStart", "timeIssueDateEnd", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListErrataRequest(String compartmentId, String erratumId, String advisoryName, Date timeIssueDateStart, Date timeIssueDateEnd, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.erratumId = erratumId;
        this.advisoryName = advisoryName;
        this.timeIssueDateStart = timeIssueDateStart;
        this.timeIssueDateEnd = timeIssueDateEnd;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getErratumId() {
        return this.erratumId;
    }

    public String getAdvisoryName() {
        return this.advisoryName;
    }

    public Date getTimeIssueDateStart() {
        return this.timeIssueDateStart;
    }

    public Date getTimeIssueDateEnd() {
        return this.timeIssueDateEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListErrataRequest, Void> {
        private String compartmentId;
        private String erratumId;
        private String advisoryName;
        private Date timeIssueDateStart;
        private Date timeIssueDateEnd;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListErrataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.erratumId(o.getErratumId());
            this.advisoryName(o.getAdvisoryName());
            this.timeIssueDateStart(o.getTimeIssueDateStart());
            this.timeIssueDateEnd(o.getTimeIssueDateEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListErrataRequest build() {
            ListErrataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder erratumId(String erratumId) {
            this.erratumId = erratumId;
            return this;
        }

        public Builder advisoryName(String advisoryName) {
            this.advisoryName = advisoryName;
            return this;
        }

        public Builder timeIssueDateStart(Date timeIssueDateStart) {
            this.timeIssueDateStart = timeIssueDateStart;
            return this;
        }

        public Builder timeIssueDateEnd(Date timeIssueDateEnd) {
            this.timeIssueDateEnd = timeIssueDateEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListErrataRequest buildWithoutInvocationCallback() {
            return new ListErrataRequest(this.compartmentId, this.erratumId, this.advisoryName, this.timeIssueDateStart, this.timeIssueDateEnd, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListErrataRequest.Builder(compartmentId=" + this.compartmentId + ", erratumId=" + this.erratumId + ", advisoryName=" + this.advisoryName + ", timeIssueDateStart=" + this.timeIssueDateStart + ", timeIssueDateEnd=" + this.timeIssueDateEnd + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Issuedate("ISSUEDATE"),
        Advisoryname("ADVISORYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

