/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetWindowsUpdateRequest
extends BmcRequest<Void> {
    private String windowsUpdate;
    private String opcRequestId;

    @ConstructorProperties(value={"windowsUpdate", "opcRequestId"})
    GetWindowsUpdateRequest(String windowsUpdate, String opcRequestId) {
        this.windowsUpdate = windowsUpdate;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWindowsUpdate() {
        return this.windowsUpdate;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWindowsUpdateRequest, Void> {
        private String windowsUpdate;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWindowsUpdateRequest o) {
            this.windowsUpdate(o.getWindowsUpdate());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWindowsUpdateRequest build() {
            GetWindowsUpdateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder windowsUpdate(String windowsUpdate) {
            this.windowsUpdate = windowsUpdate;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetWindowsUpdateRequest buildWithoutInvocationCallback() {
            return new GetWindowsUpdateRequest(this.windowsUpdate, this.opcRequestId);
        }

        public String toString() {
            return "GetWindowsUpdateRequest.Builder(windowsUpdate=" + this.windowsUpdate + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

