/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.WorkRequestError;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestErrorsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private Float retryAfter;
    private List<WorkRequestError> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "retryAfter", "items"})
    ListWorkRequestErrorsResponse(String opcRequestId, String opcNextPage, Float retryAfter, List<WorkRequestError> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.retryAfter = retryAfter;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public List<WorkRequestError> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private Float retryAfter;
        private List<WorkRequestError> items;

        public Builder copy(ListWorkRequestErrorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.retryAfter(o.getRetryAfter());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder items(List<WorkRequestError> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestErrorsResponse build() {
            return new ListWorkRequestErrorsResponse(this.opcRequestId, this.opcNextPage, this.retryAfter, this.items);
        }

        public String toString() {
            return "ListWorkRequestErrorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", retryAfter=" + this.retryAfter + ", items=" + this.items + ")";
        }
    }
}

