/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ManagedInstance;
import java.beans.ConstructorProperties;

public class GetManagedInstanceResponse {
    private String opcRequestId;
    private ManagedInstance managedInstance;

    @ConstructorProperties(value={"opcRequestId", "managedInstance"})
    GetManagedInstanceResponse(String opcRequestId, ManagedInstance managedInstance) {
        this.opcRequestId = opcRequestId;
        this.managedInstance = managedInstance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ManagedInstance getManagedInstance() {
        return this.managedInstance;
    }

    public static class Builder {
        private String opcRequestId;
        private ManagedInstance managedInstance;

        public Builder copy(GetManagedInstanceResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.managedInstance(o.getManagedInstance());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder managedInstance(ManagedInstance managedInstance) {
            this.managedInstance = managedInstance;
            return this;
        }

        public GetManagedInstanceResponse build() {
            return new GetManagedInstanceResponse(this.opcRequestId, this.managedInstance);
        }

        public String toString() {
            return "GetManagedInstanceResponse.Builder(opcRequestId=" + this.opcRequestId + ", managedInstance=" + this.managedInstance + ")";
        }
    }
}

