/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class InstallAllWindowsUpdatesOnManagedInstanceRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"managedInstanceId", "opcRequestId", "opcRetryToken"})
    InstallAllWindowsUpdatesOnManagedInstanceRequest(String managedInstanceId, String opcRequestId, String opcRetryToken) {
        this.managedInstanceId = managedInstanceId;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<InstallAllWindowsUpdatesOnManagedInstanceRequest, Void> {
        private String managedInstanceId;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstallAllWindowsUpdatesOnManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstallAllWindowsUpdatesOnManagedInstanceRequest build() {
            InstallAllWindowsUpdatesOnManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public InstallAllWindowsUpdatesOnManagedInstanceRequest buildWithoutInvocationCallback() {
            return new InstallAllWindowsUpdatesOnManagedInstanceRequest(this.managedInstanceId, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "InstallAllWindowsUpdatesOnManagedInstanceRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

