/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ManagedInstanceGroup;
import java.beans.ConstructorProperties;

public class UpdateManagedInstanceGroupResponse {
    private String etag;
    private String opcRequestId;
    private ManagedInstanceGroup managedInstanceGroup;

    @ConstructorProperties(value={"etag", "opcRequestId", "managedInstanceGroup"})
    UpdateManagedInstanceGroupResponse(String etag, String opcRequestId, ManagedInstanceGroup managedInstanceGroup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.managedInstanceGroup = managedInstanceGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ManagedInstanceGroup getManagedInstanceGroup() {
        return this.managedInstanceGroup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ManagedInstanceGroup managedInstanceGroup;

        public Builder copy(UpdateManagedInstanceGroupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.managedInstanceGroup(o.getManagedInstanceGroup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder managedInstanceGroup(ManagedInstanceGroup managedInstanceGroup) {
            this.managedInstanceGroup = managedInstanceGroup;
            return this;
        }

        public UpdateManagedInstanceGroupResponse build() {
            return new UpdateManagedInstanceGroupResponse(this.etag, this.opcRequestId, this.managedInstanceGroup);
        }

        public String toString() {
            return "UpdateManagedInstanceGroupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", managedInstanceGroup=" + this.managedInstanceGroup + ")";
        }
    }
}

