/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osmanagement.OsManagementAsync;
import com.oracle.bmc.osmanagement.internal.http.AddPackagesToSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachChildSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachManagedInstanceToManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachParentSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeManagedInstanceGroupCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeScheduledJobCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeSoftwareSourceCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachChildSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachManagedInstanceFromManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachParentSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetErratumConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.GetScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwarePackageConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWindowsUpdateConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllPackageUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllWindowsUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallWindowsUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailablePackagesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableSoftwareSourcesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableWindowsUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceGroupsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstancesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListPackagesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListUpcomingScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackageFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackagesFromSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.RunScheduledJobNowConverter;
import com.oracle.bmc.osmanagement.internal.http.SearchSoftwarePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.SkipNextScheduledJobExecutionConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementAsyncClient
implements OsManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OsManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OsManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).additionalClientConfigurators(authenticationDetailsConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddPackagesToSoftwareSourceResponse> addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request, AsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse> handler) {
        LOG.trace("Called async addPackagesToSoftwareSource");
        final AddPackagesToSoftwareSourceRequest interceptedRequest = AddPackagesToSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AddPackagesToSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AddPackagesToSoftwareSourceResponse> transformer = AddPackagesToSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AddPackagesToSoftwareSourceRequest, AddPackagesToSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<AttachChildSoftwareSourceToManagedInstanceResponse> attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse> handler) {
        LOG.trace("Called async attachChildSoftwareSourceToManagedInstance");
        final AttachChildSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachChildSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachChildSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = AttachChildSoftwareSourceToManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachChildSoftwareSourceToManagedInstanceRequest, AttachChildSoftwareSourceToManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<AttachManagedInstanceToManagedInstanceGroupResponse> attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request, AsyncHandler<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async attachManagedInstanceToManagedInstanceGroup");
        final AttachManagedInstanceToManagedInstanceGroupRequest interceptedRequest = AttachManagedInstanceToManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachManagedInstanceToManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachManagedInstanceToManagedInstanceGroupResponse> transformer = AttachManagedInstanceToManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachManagedInstanceToManagedInstanceGroupRequest, AttachManagedInstanceToManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<AttachParentSoftwareSourceToManagedInstanceResponse> attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request, AsyncHandler<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse> handler) {
        LOG.trace("Called async attachParentSoftwareSourceToManagedInstance");
        final AttachParentSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachParentSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachParentSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachParentSoftwareSourceToManagedInstanceResponse> transformer = AttachParentSoftwareSourceToManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachParentSoftwareSourceToManagedInstanceRequest, AttachParentSoftwareSourceToManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ChangeManagedInstanceGroupCompartmentResponse> changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request, AsyncHandler<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeManagedInstanceGroupCompartment");
        final ChangeManagedInstanceGroupCompartmentRequest interceptedRequest = ChangeManagedInstanceGroupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeManagedInstanceGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeManagedInstanceGroupCompartmentResponse> transformer = ChangeManagedInstanceGroupCompartmentConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeManagedInstanceGroupCompartmentRequest, ChangeManagedInstanceGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ChangeScheduledJobCompartmentResponse> changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request, AsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse> handler) {
        LOG.trace("Called async changeScheduledJobCompartment");
        final ChangeScheduledJobCompartmentRequest interceptedRequest = ChangeScheduledJobCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeScheduledJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeScheduledJobCompartmentResponse> transformer = ChangeScheduledJobCompartmentConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeScheduledJobCompartmentRequest, ChangeScheduledJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ChangeSoftwareSourceCompartmentResponse> changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request, AsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse> handler) {
        LOG.trace("Called async changeSoftwareSourceCompartment");
        final ChangeSoftwareSourceCompartmentRequest interceptedRequest = ChangeSoftwareSourceCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSoftwareSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSoftwareSourceCompartmentResponse> transformer = ChangeSoftwareSourceCompartmentConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSoftwareSourceCompartmentRequest, ChangeSoftwareSourceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<CreateManagedInstanceGroupResponse> createManagedInstanceGroup(CreateManagedInstanceGroupRequest request, AsyncHandler<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async createManagedInstanceGroup");
        final CreateManagedInstanceGroupRequest interceptedRequest = CreateManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateManagedInstanceGroupResponse> transformer = CreateManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateManagedInstanceGroupRequest, CreateManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<CreateScheduledJobResponse> createScheduledJob(CreateScheduledJobRequest request, AsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse> handler) {
        LOG.trace("Called async createScheduledJob");
        final CreateScheduledJobRequest interceptedRequest = CreateScheduledJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateScheduledJobResponse> transformer = CreateScheduledJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateScheduledJobRequest, CreateScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateScheduledJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getCreateScheduledJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateScheduledJobDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<CreateSoftwareSourceResponse> createSoftwareSource(CreateSoftwareSourceRequest request, AsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse> handler) {
        LOG.trace("Called async createSoftwareSource");
        final CreateSoftwareSourceRequest interceptedRequest = CreateSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSoftwareSourceResponse> transformer = CreateSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSoftwareSourceRequest, CreateSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DeleteManagedInstanceGroupResponse> deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request, AsyncHandler<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async deleteManagedInstanceGroup");
        final DeleteManagedInstanceGroupRequest interceptedRequest = DeleteManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteManagedInstanceGroupResponse> transformer = DeleteManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteManagedInstanceGroupRequest, DeleteManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DeleteScheduledJobResponse> deleteScheduledJob(DeleteScheduledJobRequest request, AsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse> handler) {
        LOG.trace("Called async deleteScheduledJob");
        final DeleteScheduledJobRequest interceptedRequest = DeleteScheduledJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteScheduledJobResponse> transformer = DeleteScheduledJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteScheduledJobRequest, DeleteScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSoftwareSourceResponse> deleteSoftwareSource(DeleteSoftwareSourceRequest request, AsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse> handler) {
        LOG.trace("Called async deleteSoftwareSource");
        final DeleteSoftwareSourceRequest interceptedRequest = DeleteSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSoftwareSourceResponse> transformer = DeleteSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSoftwareSourceRequest, DeleteSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.delete(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.delete(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DetachChildSoftwareSourceFromManagedInstanceResponse> detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse> handler) {
        LOG.trace("Called async detachChildSoftwareSourceFromManagedInstance");
        final DetachChildSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachChildSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachChildSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachChildSoftwareSourceFromManagedInstanceResponse> transformer = DetachChildSoftwareSourceFromManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachChildSoftwareSourceFromManagedInstanceRequest, DetachChildSoftwareSourceFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DetachManagedInstanceFromManagedInstanceGroupResponse> detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request, AsyncHandler<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async detachManagedInstanceFromManagedInstanceGroup");
        final DetachManagedInstanceFromManagedInstanceGroupRequest interceptedRequest = DetachManagedInstanceFromManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachManagedInstanceFromManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachManagedInstanceFromManagedInstanceGroupResponse> transformer = DetachManagedInstanceFromManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachManagedInstanceFromManagedInstanceGroupRequest, DetachManagedInstanceFromManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<DetachParentSoftwareSourceFromManagedInstanceResponse> detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request, AsyncHandler<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse> handler) {
        LOG.trace("Called async detachParentSoftwareSourceFromManagedInstance");
        final DetachParentSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachParentSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachParentSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachParentSoftwareSourceFromManagedInstanceResponse> transformer = DetachParentSoftwareSourceFromManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachParentSoftwareSourceFromManagedInstanceRequest, DetachParentSoftwareSourceFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetErratumResponse> getErratum(GetErratumRequest request, AsyncHandler<GetErratumRequest, GetErratumResponse> handler) {
        LOG.trace("Called async getErratum");
        final GetErratumRequest interceptedRequest = GetErratumConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetErratumConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetErratumResponse> transformer = GetErratumConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetErratumRequest, GetErratumResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetManagedInstanceResponse> getManagedInstance(GetManagedInstanceRequest request, AsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse> handler) {
        LOG.trace("Called async getManagedInstance");
        final GetManagedInstanceRequest interceptedRequest = GetManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetManagedInstanceResponse> transformer = GetManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetManagedInstanceRequest, GetManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetManagedInstanceGroupResponse> getManagedInstanceGroup(GetManagedInstanceGroupRequest request, AsyncHandler<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async getManagedInstanceGroup");
        final GetManagedInstanceGroupRequest interceptedRequest = GetManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetManagedInstanceGroupResponse> transformer = GetManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetManagedInstanceGroupRequest, GetManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetScheduledJobResponse> getScheduledJob(GetScheduledJobRequest request, AsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse> handler) {
        LOG.trace("Called async getScheduledJob");
        final GetScheduledJobRequest interceptedRequest = GetScheduledJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetScheduledJobResponse> transformer = GetScheduledJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetScheduledJobRequest, GetScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetSoftwarePackageResponse> getSoftwarePackage(GetSoftwarePackageRequest request, AsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse> handler) {
        LOG.trace("Called async getSoftwarePackage");
        final GetSoftwarePackageRequest interceptedRequest = GetSoftwarePackageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSoftwarePackageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSoftwarePackageResponse> transformer = GetSoftwarePackageConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSoftwarePackageRequest, GetSoftwarePackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetSoftwareSourceResponse> getSoftwareSource(GetSoftwareSourceRequest request, AsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse> handler) {
        LOG.trace("Called async getSoftwareSource");
        final GetSoftwareSourceRequest interceptedRequest = GetSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSoftwareSourceResponse> transformer = GetSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSoftwareSourceRequest, GetSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetWindowsUpdateResponse> getWindowsUpdate(GetWindowsUpdateRequest request, AsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse> handler) {
        LOG.trace("Called async getWindowsUpdate");
        final GetWindowsUpdateRequest interceptedRequest = GetWindowsUpdateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWindowsUpdateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWindowsUpdateResponse> transformer = GetWindowsUpdateConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWindowsUpdateRequest, GetWindowsUpdateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<InstallAllPackageUpdatesOnManagedInstanceResponse> installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installAllPackageUpdatesOnManagedInstance");
        final InstallAllPackageUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllPackageUpdatesOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstallAllPackageUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstallAllPackageUpdatesOnManagedInstanceResponse> transformer = InstallAllPackageUpdatesOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstallAllPackageUpdatesOnManagedInstanceRequest, InstallAllPackageUpdatesOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<InstallAllWindowsUpdatesOnManagedInstanceResponse> installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request, AsyncHandler<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installAllWindowsUpdatesOnManagedInstance");
        final InstallAllWindowsUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllWindowsUpdatesOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstallAllWindowsUpdatesOnManagedInstanceResponse> transformer = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstallAllWindowsUpdatesOnManagedInstanceRequest, InstallAllWindowsUpdatesOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<InstallPackageOnManagedInstanceResponse> installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request, AsyncHandler<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installPackageOnManagedInstance");
        final InstallPackageOnManagedInstanceRequest interceptedRequest = InstallPackageOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstallPackageOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstallPackageOnManagedInstanceResponse> transformer = InstallPackageOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstallPackageOnManagedInstanceRequest, InstallPackageOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<InstallPackageUpdateOnManagedInstanceResponse> installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request, AsyncHandler<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installPackageUpdateOnManagedInstance");
        final InstallPackageUpdateOnManagedInstanceRequest interceptedRequest = InstallPackageUpdateOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstallPackageUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstallPackageUpdateOnManagedInstanceResponse> transformer = InstallPackageUpdateOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstallPackageUpdateOnManagedInstanceRequest, InstallPackageUpdateOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<InstallWindowsUpdateOnManagedInstanceResponse> installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request, AsyncHandler<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse> handler) {
        LOG.trace("Called async installWindowsUpdateOnManagedInstance");
        final InstallWindowsUpdateOnManagedInstanceRequest interceptedRequest = InstallWindowsUpdateOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = InstallWindowsUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, InstallWindowsUpdateOnManagedInstanceResponse> transformer = InstallWindowsUpdateOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<InstallWindowsUpdateOnManagedInstanceRequest, InstallWindowsUpdateOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListAvailablePackagesForManagedInstanceResponse> listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request, AsyncHandler<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailablePackagesForManagedInstance");
        final ListAvailablePackagesForManagedInstanceRequest interceptedRequest = ListAvailablePackagesForManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAvailablePackagesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAvailablePackagesForManagedInstanceResponse> transformer = ListAvailablePackagesForManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAvailablePackagesForManagedInstanceRequest, ListAvailablePackagesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListAvailableSoftwareSourcesForManagedInstanceResponse> listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request, AsyncHandler<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableSoftwareSourcesForManagedInstance");
        final ListAvailableSoftwareSourcesForManagedInstanceRequest interceptedRequest = ListAvailableSoftwareSourcesForManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAvailableSoftwareSourcesForManagedInstanceResponse> transformer = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAvailableSoftwareSourcesForManagedInstanceRequest, ListAvailableSoftwareSourcesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListAvailableUpdatesForManagedInstanceResponse> listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableUpdatesForManagedInstance");
        final ListAvailableUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableUpdatesForManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAvailableUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAvailableUpdatesForManagedInstanceResponse> transformer = ListAvailableUpdatesForManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAvailableUpdatesForManagedInstanceRequest, ListAvailableUpdatesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListAvailableWindowsUpdatesForManagedInstanceResponse> listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request, AsyncHandler<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse> handler) {
        LOG.trace("Called async listAvailableWindowsUpdatesForManagedInstance");
        final ListAvailableWindowsUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableWindowsUpdatesForManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAvailableWindowsUpdatesForManagedInstanceResponse> transformer = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAvailableWindowsUpdatesForManagedInstanceRequest, ListAvailableWindowsUpdatesForManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListManagedInstanceGroupsResponse> listManagedInstanceGroups(ListManagedInstanceGroupsRequest request, AsyncHandler<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse> handler) {
        LOG.trace("Called async listManagedInstanceGroups");
        final ListManagedInstanceGroupsRequest interceptedRequest = ListManagedInstanceGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListManagedInstanceGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListManagedInstanceGroupsResponse> transformer = ListManagedInstanceGroupsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListManagedInstanceGroupsRequest, ListManagedInstanceGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListManagedInstancesResponse> listManagedInstances(ListManagedInstancesRequest request, AsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse> handler) {
        LOG.trace("Called async listManagedInstances");
        final ListManagedInstancesRequest interceptedRequest = ListManagedInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListManagedInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListManagedInstancesResponse> transformer = ListManagedInstancesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListManagedInstancesRequest, ListManagedInstancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListPackagesInstalledOnManagedInstanceResponse> listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request, AsyncHandler<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listPackagesInstalledOnManagedInstance");
        final ListPackagesInstalledOnManagedInstanceRequest interceptedRequest = ListPackagesInstalledOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPackagesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPackagesInstalledOnManagedInstanceResponse> transformer = ListPackagesInstalledOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPackagesInstalledOnManagedInstanceRequest, ListPackagesInstalledOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListScheduledJobsResponse> listScheduledJobs(ListScheduledJobsRequest request, AsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse> handler) {
        LOG.trace("Called async listScheduledJobs");
        final ListScheduledJobsRequest interceptedRequest = ListScheduledJobsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListScheduledJobsResponse> transformer = ListScheduledJobsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListScheduledJobsRequest, ListScheduledJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListSoftwareSourcePackagesResponse> listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request, AsyncHandler<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse> handler) {
        LOG.trace("Called async listSoftwareSourcePackages");
        final ListSoftwareSourcePackagesRequest interceptedRequest = ListSoftwareSourcePackagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSoftwareSourcePackagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSoftwareSourcePackagesResponse> transformer = ListSoftwareSourcePackagesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSoftwareSourcePackagesRequest, ListSoftwareSourcePackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListSoftwareSourcesResponse> listSoftwareSources(ListSoftwareSourcesRequest request, AsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse> handler) {
        LOG.trace("Called async listSoftwareSources");
        final ListSoftwareSourcesRequest interceptedRequest = ListSoftwareSourcesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSoftwareSourcesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSoftwareSourcesResponse> transformer = ListSoftwareSourcesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSoftwareSourcesRequest, ListSoftwareSourcesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListUpcomingScheduledJobsResponse> listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request, AsyncHandler<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse> handler) {
        LOG.trace("Called async listUpcomingScheduledJobs");
        final ListUpcomingScheduledJobsRequest interceptedRequest = ListUpcomingScheduledJobsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListUpcomingScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListUpcomingScheduledJobsResponse> transformer = ListUpcomingScheduledJobsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListUpcomingScheduledJobsRequest, ListUpcomingScheduledJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWindowsUpdatesResponse> listWindowsUpdates(ListWindowsUpdatesRequest request, AsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse> handler) {
        LOG.trace("Called async listWindowsUpdates");
        final ListWindowsUpdatesRequest interceptedRequest = ListWindowsUpdatesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWindowsUpdatesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWindowsUpdatesResponse> transformer = ListWindowsUpdatesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWindowsUpdatesRequest, ListWindowsUpdatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWindowsUpdatesInstalledOnManagedInstanceResponse> listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request, AsyncHandler<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse> handler) {
        LOG.trace("Called async listWindowsUpdatesInstalledOnManagedInstance");
        final ListWindowsUpdatesInstalledOnManagedInstanceRequest interceptedRequest = ListWindowsUpdatesInstalledOnManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWindowsUpdatesInstalledOnManagedInstanceResponse> transformer = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWindowsUpdatesInstalledOnManagedInstanceRequest, ListWindowsUpdatesInstalledOnManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<RemovePackageFromManagedInstanceResponse> removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request, AsyncHandler<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse> handler) {
        LOG.trace("Called async removePackageFromManagedInstance");
        final RemovePackageFromManagedInstanceRequest interceptedRequest = RemovePackageFromManagedInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RemovePackageFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RemovePackageFromManagedInstanceResponse> transformer = RemovePackageFromManagedInstanceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RemovePackageFromManagedInstanceRequest, RemovePackageFromManagedInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<RemovePackagesFromSoftwareSourceResponse> removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request, AsyncHandler<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse> handler) {
        LOG.trace("Called async removePackagesFromSoftwareSource");
        final RemovePackagesFromSoftwareSourceRequest interceptedRequest = RemovePackagesFromSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RemovePackagesFromSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RemovePackagesFromSoftwareSourceResponse> transformer = RemovePackagesFromSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (Object)interceptedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (Object)interceptedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<RunScheduledJobNowResponse> runScheduledJobNow(RunScheduledJobNowRequest request, AsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse> handler) {
        LOG.trace("Called async runScheduledJobNow");
        final RunScheduledJobNowRequest interceptedRequest = RunScheduledJobNowConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RunScheduledJobNowConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RunScheduledJobNowResponse> transformer = RunScheduledJobNowConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RunScheduledJobNowRequest, RunScheduledJobNowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<SearchSoftwarePackagesResponse> searchSoftwarePackages(SearchSoftwarePackagesRequest request, AsyncHandler<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse> handler) {
        LOG.trace("Called async searchSoftwarePackages");
        final SearchSoftwarePackagesRequest interceptedRequest = SearchSoftwarePackagesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SearchSoftwarePackagesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SearchSoftwarePackagesResponse> transformer = SearchSoftwarePackagesConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SearchSoftwarePackagesRequest, SearchSoftwarePackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.get(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.get(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<SkipNextScheduledJobExecutionResponse> skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request, AsyncHandler<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse> handler) {
        LOG.trace("Called async skipNextScheduledJobExecution");
        final SkipNextScheduledJobExecutionRequest interceptedRequest = SkipNextScheduledJobExecutionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SkipNextScheduledJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SkipNextScheduledJobExecutionResponse> transformer = SkipNextScheduledJobExecutionConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SkipNextScheduledJobExecutionRequest, SkipNextScheduledJobExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.post(ib, (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.post(ib, (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<UpdateManagedInstanceGroupResponse> updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request, AsyncHandler<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse> handler) {
        LOG.trace("Called async updateManagedInstanceGroup");
        final UpdateManagedInstanceGroupRequest interceptedRequest = UpdateManagedInstanceGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateManagedInstanceGroupResponse> transformer = UpdateManagedInstanceGroupConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateManagedInstanceGroupRequest, UpdateManagedInstanceGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.put(ib, (Object)interceptedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<UpdateScheduledJobResponse> updateScheduledJob(UpdateScheduledJobRequest request, AsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse> handler) {
        LOG.trace("Called async updateScheduledJob");
        final UpdateScheduledJobRequest interceptedRequest = UpdateScheduledJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateScheduledJobResponse> transformer = UpdateScheduledJobConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateScheduledJobRequest, UpdateScheduledJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateScheduledJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.put(ib, (Object)interceptedRequest.getUpdateScheduledJobDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateScheduledJobDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSoftwareSourceResponse> updateSoftwareSource(UpdateSoftwareSourceRequest request, AsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse> handler) {
        LOG.trace("Called async updateSoftwareSource");
        final UpdateSoftwareSourceRequest interceptedRequest = UpdateSoftwareSourceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSoftwareSourceResponse> transformer = UpdateSoftwareSourceConverter.fromResponse();
        Object handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSoftwareSourceRequest, UpdateSoftwareSourceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handler){

                public void retryCall() {
                    SuccessConsumer onSuccess = new SuccessConsumer((AsyncHandler)this, transformer, (Object)interceptedRequest);
                    ErrorConsumer onError = new ErrorConsumer((AsyncHandler)this, (Object)interceptedRequest);
                    OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
                }
            };
        }
        SuccessConsumer onSuccess = handler == null ? null : new SuccessConsumer(handlerToUse, transformer, (Object)interceptedRequest);
        ErrorConsumer onError = handler == null ? null : new ErrorConsumer(handlerToUse, (Object)interceptedRequest);
        Future responseFuture = this.client.put(ib, (Object)interceptedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, (Consumer)onSuccess, (Consumer)onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (Supplier)new Supplier<Future<Response>>((Consumer)onSuccess, (Consumer)onError){
                final /* synthetic */ Consumer val$onSuccess;
                final /* synthetic */ Consumer val$onError;
                {
                    this.val$onSuccess = consumer;
                    this.val$onError = consumer2;
                }

                public Future<Response> get() {
                    return OsManagementAsyncClient.this.client.put(ib, (Object)interceptedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)interceptedRequest, this.val$onSuccess, this.val$onError);
                }
            });
        }
        return new TransformingFuture(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OsManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new OsManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

