/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.Erratum;
import java.beans.ConstructorProperties;

public class GetErratumResponse {
    private String opcRequestId;
    private Erratum erratum;

    @ConstructorProperties(value={"opcRequestId", "erratum"})
    GetErratumResponse(String opcRequestId, Erratum erratum) {
        this.opcRequestId = opcRequestId;
        this.erratum = erratum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Erratum getErratum() {
        return this.erratum;
    }

    public static class Builder {
        private String opcRequestId;
        private Erratum erratum;

        public Builder copy(GetErratumResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.erratum(o.getErratum());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder erratum(Erratum erratum) {
            this.erratum = erratum;
            return this;
        }

        public GetErratumResponse build() {
            return new GetErratumResponse(this.opcRequestId, this.erratum);
        }

        public String toString() {
            return "GetErratumResponse.Builder(opcRequestId=" + this.opcRequestId + ", erratum=" + this.erratum + ")";
        }
    }
}

