/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ManagedInstanceGroup;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateManagedInstanceGroupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateManagedInstanceGroupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateManagedInstanceGroupRequest interceptRequest(CreateManagedInstanceGroupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateManagedInstanceGroupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateManagedInstanceGroupDetails(), (String)"createManagedInstanceGroupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstanceGroups");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateManagedInstanceGroupResponse> fromResponse() {
        Function<Response, CreateManagedInstanceGroupResponse> transformer = new Function<Response, CreateManagedInstanceGroupResponse>(){

            public CreateManagedInstanceGroupResponse apply(Response rawResponse) {
                Optional etagHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ManagedInstanceGroup.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateManagedInstanceGroupResponse.Builder builder = CreateManagedInstanceGroupResponse.builder();
                builder.managedInstanceGroup((ManagedInstanceGroup)response.getItem());
                Optional locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Location");
                if (locationHeader.isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"Location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                CreateManagedInstanceGroupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

