/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ScheduledJob;
import java.beans.ConstructorProperties;

public class CreateScheduledJobResponse {
    private String location;
    private String opcRequestId;
    private String etag;
    private ScheduledJob scheduledJob;

    @ConstructorProperties(value={"location", "opcRequestId", "etag", "scheduledJob"})
    CreateScheduledJobResponse(String location, String opcRequestId, String etag, ScheduledJob scheduledJob) {
        this.location = location;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.scheduledJob = scheduledJob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLocation() {
        return this.location;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ScheduledJob getScheduledJob() {
        return this.scheduledJob;
    }

    public static class Builder {
        private String location;
        private String opcRequestId;
        private String etag;
        private ScheduledJob scheduledJob;

        public Builder copy(CreateScheduledJobResponse o) {
            this.location(o.getLocation());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.scheduledJob(o.getScheduledJob());
            return this;
        }

        Builder() {
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder scheduledJob(ScheduledJob scheduledJob) {
            this.scheduledJob = scheduledJob;
            return this;
        }

        public CreateScheduledJobResponse build() {
            return new CreateScheduledJobResponse(this.location, this.opcRequestId, this.etag, this.scheduledJob);
        }

        public String toString() {
            return "CreateScheduledJobResponse.Builder(location=" + this.location + ", opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", scheduledJob=" + this.scheduledJob + ")";
        }
    }
}

