/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ScheduledJob;
import java.beans.ConstructorProperties;

public class UpdateScheduledJobResponse {
    private String etag;
    private String opcRequestId;
    private ScheduledJob scheduledJob;

    @ConstructorProperties(value={"etag", "opcRequestId", "scheduledJob"})
    UpdateScheduledJobResponse(String etag, String opcRequestId, ScheduledJob scheduledJob) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.scheduledJob = scheduledJob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ScheduledJob getScheduledJob() {
        return this.scheduledJob;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ScheduledJob scheduledJob;

        public Builder copy(UpdateScheduledJobResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.scheduledJob(o.getScheduledJob());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scheduledJob(ScheduledJob scheduledJob) {
            this.scheduledJob = scheduledJob;
            return this;
        }

        public UpdateScheduledJobResponse build() {
            return new UpdateScheduledJobResponse(this.etag, this.opcRequestId, this.scheduledJob);
        }

        public String toString() {
            return "UpdateScheduledJobResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", scheduledJob=" + this.scheduledJob + ")";
        }
    }
}

