/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.SoftwarePackage;
import java.beans.ConstructorProperties;

public class GetSoftwarePackageResponse {
    private String opcRequestId;
    private SoftwarePackage softwarePackage;

    @ConstructorProperties(value={"opcRequestId", "softwarePackage"})
    GetSoftwarePackageResponse(String opcRequestId, SoftwarePackage softwarePackage) {
        this.opcRequestId = opcRequestId;
        this.softwarePackage = softwarePackage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SoftwarePackage getSoftwarePackage() {
        return this.softwarePackage;
    }

    public static class Builder {
        private String opcRequestId;
        private SoftwarePackage softwarePackage;

        public Builder copy(GetSoftwarePackageResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.softwarePackage(o.getSoftwarePackage());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder softwarePackage(SoftwarePackage softwarePackage) {
            this.softwarePackage = softwarePackage;
            return this;
        }

        public GetSoftwarePackageResponse build() {
            return new GetSoftwarePackageResponse(this.opcRequestId, this.softwarePackage);
        }

        public String toString() {
            return "GetSoftwarePackageResponse.Builder(opcRequestId=" + this.opcRequestId + ", softwarePackage=" + this.softwarePackage + ")";
        }
    }
}

