/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.osmanagement.model.UpdateManagedInstanceGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateManagedInstanceGroupRequest
extends BmcRequest {
    private String managedInstanceGroupId;
    private UpdateManagedInstanceGroupDetails updateManagedInstanceGroupDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"managedInstanceGroupId", "updateManagedInstanceGroupDetails", "opcRequestId", "ifMatch"})
    UpdateManagedInstanceGroupRequest(String managedInstanceGroupId, UpdateManagedInstanceGroupDetails updateManagedInstanceGroupDetails, String opcRequestId, String ifMatch) {
        this.managedInstanceGroupId = managedInstanceGroupId;
        this.updateManagedInstanceGroupDetails = updateManagedInstanceGroupDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public UpdateManagedInstanceGroupDetails getUpdateManagedInstanceGroupDetails() {
        return this.updateManagedInstanceGroupDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String managedInstanceGroupId;
        private UpdateManagedInstanceGroupDetails updateManagedInstanceGroupDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateManagedInstanceGroupRequest o) {
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.updateManagedInstanceGroupDetails(o.getUpdateManagedInstanceGroupDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateManagedInstanceGroupRequest build() {
            UpdateManagedInstanceGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder updateManagedInstanceGroupDetails(UpdateManagedInstanceGroupDetails updateManagedInstanceGroupDetails) {
            this.updateManagedInstanceGroupDetails = updateManagedInstanceGroupDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateManagedInstanceGroupRequest buildWithoutInvocationCallback() {
            return new UpdateManagedInstanceGroupRequest(this.managedInstanceGroupId, this.updateManagedInstanceGroupDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateManagedInstanceGroupRequest.Builder(managedInstanceGroupId=" + this.managedInstanceGroupId + ", updateManagedInstanceGroupDetails=" + this.updateManagedInstanceGroupDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

