/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ManagedInstanceSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListManagedInstancesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<ManagedInstanceSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListManagedInstancesResponse(String opcRequestId, String opcNextPage, List<ManagedInstanceSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<ManagedInstanceSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<ManagedInstanceSummary> items;

        public Builder copy(ListManagedInstancesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<ManagedInstanceSummary> items) {
            this.items = items;
            return this;
        }

        public ListManagedInstancesResponse build() {
            return new ListManagedInstancesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListManagedInstancesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

