/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.osmanagement.model.ChangeSoftwareSourceCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ChangeSoftwareSourceCompartmentRequest
extends BmcRequest {
    private String softwareSourceId;
    private ChangeSoftwareSourceCompartmentDetails changeSoftwareSourceCompartmentDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    @ConstructorProperties(value={"softwareSourceId", "changeSoftwareSourceCompartmentDetails", "opcRequestId", "ifMatch", "opcRetryToken"})
    ChangeSoftwareSourceCompartmentRequest(String softwareSourceId, ChangeSoftwareSourceCompartmentDetails changeSoftwareSourceCompartmentDetails, String opcRequestId, String ifMatch, String opcRetryToken) {
        this.softwareSourceId = softwareSourceId;
        this.changeSoftwareSourceCompartmentDetails = changeSoftwareSourceCompartmentDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public ChangeSoftwareSourceCompartmentDetails getChangeSoftwareSourceCompartmentDetails() {
        return this.changeSoftwareSourceCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String softwareSourceId;
        private ChangeSoftwareSourceCompartmentDetails changeSoftwareSourceCompartmentDetails;
        private String opcRequestId;
        private String ifMatch;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSoftwareSourceCompartmentRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.changeSoftwareSourceCompartmentDetails(o.getChangeSoftwareSourceCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSoftwareSourceCompartmentRequest build() {
            ChangeSoftwareSourceCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder changeSoftwareSourceCompartmentDetails(ChangeSoftwareSourceCompartmentDetails changeSoftwareSourceCompartmentDetails) {
            this.changeSoftwareSourceCompartmentDetails = changeSoftwareSourceCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ChangeSoftwareSourceCompartmentRequest buildWithoutInvocationCallback() {
            return new ChangeSoftwareSourceCompartmentRequest(this.softwareSourceId, this.changeSoftwareSourceCompartmentDetails, this.opcRequestId, this.ifMatch, this.opcRetryToken);
        }

        public String toString() {
            return "ChangeSoftwareSourceCompartmentRequest.Builder(softwareSourceId=" + this.softwareSourceId + ", changeSoftwareSourceCompartmentDetails=" + this.changeSoftwareSourceCompartmentDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

